#include <target/htypes.h>
#include <ns9750/ioregs.h>

struct serial_reg_info {
  u32 status_a;
  u32 fifo_data;
};

struct serial_reg_info ser_info[] = {
  [0] = { /* not support serial channel */
    .status_a	= 0,
    .fifo_data	= 0,
  },
  [1] = { /* CH:A */
    .status_a	= NS_SER_CHA_STATUS_A,
    .fifo_data	= NS_SER_CHA_FIFO_DATA,
  },
  [2] = { /* CH:B */
    .status_a	= NS_SER_CHB_STATUS_A,
    .fifo_data	= NS_SER_CHB_FIFO_DATA,
  },
};

static unsigned int channel = 1;

int change_serial_channel(unsigned int ch)
{
  if(ch > 2) return -1;
  channel = ch;
  return 0;
}

int arch_getchar(unsigned long timeout)
{
	static unsigned long data;
	static unsigned char rxfdb = 0;

	if(channel == 0) return 0;

	if (!rxfdb) {
		unsigned long status;
		while(1){
		  status = IO_SER(WORD, ser_info[channel].status_a);
		  if(status & SER_STATUS_RRDY) break;
		  if(status & SER_STATUS_RBC){
		    IO_SER(WORD, ser_info[channel].status_a) = SER_STATUS_RBC;
		  }
		}
		rxfdb = SER_STATUS_RXFDB(status);
		data = IO_SER(WORD, ser_info[channel].fifo_data);
		if (!rxfdb) {
			rxfdb = 4;
		}
	}
	else {
		data >>= 8;
	}
	rxfdb--;
	return (data & 0xff);
}

int arch_putchar(int c, unsigned long timeout)
{
	unsigned long status;

	if(channel == 0) return 0;

	while(1){
	  status = IO_SER(WORD, ser_info[channel].status_a);
	  if(status & SER_STATUS_TRDY) break;
	}
	IO_SER(BYTE, ser_info[channel].fifo_data) = (unsigned char) c;

	return 0;
}

