#ifndef _BOARD_H_
#define _BOARD_H_

#include <ep93xx/ioregs.h>

#define JP_MODE_BIT 0x80

#define LED_GREEN_ON()  ((!get_board_id()) \
			   ?({IO_GPIO_PEDDR |= 0x02; IO_GPIO_PEDR |= 0x02;}) \
			   :({IO_GPIO_PEDDR |= 0x01; IO_GPIO_PEDR |= 0x01;}))
#define LED_GREEN_OFF() ((!get_board_id()) \
			   ?({IO_GPIO_PEDDR |= 0x02; IO_GPIO_PEDR &= ~0x02;}) \
			   :({IO_GPIO_PEDDR |= 0x01; IO_GPIO_PEDR &= ~0x01;}))
#define LED_RED_ON()    ((!get_board_id()) \
			   ?({IO_GPIO_PEDDR |= 0x01; IO_GPIO_PEDR |= 0x01;}) \
			   :({IO_GPIO_PCDDR |= 0x80; IO_GPIO_PCDR |= 0x80;}))
#define LED_RED_OFF()   ((!get_board_id()) \
			   ?({IO_GPIO_PEDDR |= 0x01; IO_GPIO_PEDR &= ~0x01;}) \
			   :({IO_GPIO_PCDDR |= 0x80; IO_GPIO_PCDR &= ~0x80;}))

typedef enum _board_id_e{
  BOARD_ID_UNKONWN = -1,
  BOARD_ID_A210 = 0,
  BOARD_ID_A220,
  BOARD_ID_A230,
  BOARD_ID_A240,
  BOARD_ID_A210C,
}board_id_e;

#define SDRAM_16Bit 0
#define SDRAM_32Bit 1

typedef struct{
  int id;
  int flash;
  int sdram;
}board_type;
extern board_type board_info;

extern int jumper_mode;
void udelay(unsigned long usec);
void mdelay(unsigned long msec);

#define get_board_id() ((IO_GPIO_PHDR >> 2) & 0x7)
#ifdef BOOTMODE
#define get_board_sdram32bit() 0
#else
#define get_board_sdram32bit() ((IO_GPIO_PHDR >> 5) & 0x1)
#endif
extern char *get_board_name(int id);
extern void board_init(void);
extern int check_mode_jumper(void);

#include <target/command.h>
extern const command_t info_command;
#endif
