
#ifndef _HERMIT_ETH_UTIL_H_
#define _HERMIT_ETH_UTIL_H_

#if defined(DEBUG_ETH)
#define _DEBUG(args...) hprintf(args)
#else
#define _DEBUG(args...)
#endif

#include <hermit.h>

unsigned short htons(unsigned short hostshort);
unsigned long htonl(unsigned long hostlong);
unsigned short ntohs(unsigned short netshort);
unsigned long ntohl(unsigned long netlong);

int safe_memcmp(const void *__str1, const void *__str2, const int __len);
void *safe_memcpy(void *__dst, const void *__src, const int __len);
void *safe_memset(void *__src, const int __c, const int __len);
int safe_strlen(const char *str);
int safe_strcmp(const char *str1, const char *str2);
int safe_strncmp(const char *str1, const char *str2, unsigned int n);
  
void print_ip(unsigned char *ip);
void print_mac(unsigned char *mac);

#if defined(DEBUG_ETH)
void hexdump(char *str, unsigned char *buf, unsigned int len);
#else
#define hexdump(a,b,c)
#endif
#endif
