/*
 * Copyright (C) 2003-2005 Atmark Techno, Inc.  All Rights Reserved.
 */

#ifndef _HERMIT_SUZAKU_MEMREGIONS_H
#define _HERMIT_SUZAKU_MEMREGIONS_H

#include <target/ioregs.h>

#define KiB                 (1024)

#ifdef __MICROBLAZE__

#define FLASH_START         (XPAR_SYSTEM_MEMCON_MEM1_BASEADDR)
#define FLASH_SIZE          (XPAR_SYSTEM_MEMCON_MEM1_HIGHADDR - XPAR_SYSTEM_MEMCON_MEM1_BASEADDR + 1)

#define DRAM_BASEADDR        XPAR_SDRAM_CONTROLLER_BASEADDR
#define DRAM_START           DRAM_BASEADDR
#define DRAM_SIZE            XPAR_SDRAM_CONTROLLER_HIGHADDR - XPAR_SDRAM_CONTROLLER_BASEADDR + 1
#define DRAM_END            (DRAM_START + DRAM_SIZE - 1)

#elif defined(__PPC__) || defined(__powerpc__)

#define FLASH_START         (XPAR_SYSTEM_MEMCON_MEM1_BASEADDR)
#define FLASH_SIZE          (XPAR_SYSTEM_MEMCON_MEM1_HIGHADDR - XPAR_SYSTEM_MEMCON_MEM1_BASEADDR + 1)

#define DRAM_BASEADDR        XPAR_SDRAM_CONTROLLER_BASEADDR
#define DRAM_START           DRAM_BASEADDR
#define DRAM_SIZE            XPAR_SDRAM_CONTROLLER_HIGHADDR - XPAR_SDRAM_CONTROLLER_BASEADDR + 1
#define DRAM_END            (DRAM_START + DRAM_SIZE - 1)

#else
#error Unknown arch
#endif

#define START_ADDRESS       (DRAM_END - 0x00100000)

#include "memregions_4MiB.h"
#include "memregions_8MiB.h"
#include "memregions_spi.h"

#ifndef __ASSEMBLER__
#include "flash_region.h"

#define LINUX_SRC_ADDRESS       (flash_region_get_start_address(FlashRegionIdImage))
#define LINUX_SRC_SIZE          (flash_region_get_size(FlashRegionIdImage))
#define LINUX_LOAD_ADDRESS      (DRAM_BASEADDR)


#define INITRD_SRC_SIZE         (0x00200000)
#define INITRD_SRC_ADDRESS      (0)
#define INITRD_LOAD_ADDRESS     (DRAM_BASEADDR + 0x00300000)

extern char __bss_end;

#define GUNZIP_MEM_SIZE 0x40000
#define GUNZIP_MEM_BASE (&__bss_end)
#endif

#endif /* _HERMIT_SUZAKU_MEMREGIONS_H */
