/*
 * Copyright (c) 2005 Atmark Techno, Inc. All Rights Reserved.
 */

#include <target/mem.h>

int memcmp(const void *__s1, const void *__s2, size_t __n)
{
	const unsigned char *su1, *su2;
	int res = 0;

	for( su1 = __s1, su2 = __s2; 0 < __n; ++su1, ++su2, __n--)
		if ((res = *su1 - *su2) != 0)
			break;
	return res;
}

void *memcpy(void *__dest, const void *__src, size_t __n)
{
	int i = 0;
	unsigned char *d = __dest;
	unsigned const char *s = __src;

	for (i = (__n >> 3); i > 0; i--) {
		*d++ = *s++;
		*d++ = *s++;
		*d++ = *s++;
		*d++ = *s++;
		*d++ = *s++;
		*d++ = *s++;
		*d++ = *s++;
		*d++ = *s++;
	}

	if (__n & (1 << 2)) {
		*d++ = *s++;
		*d++ = *s++;
		*d++ = *s++;
		*d++ = *s++;
	}

	if (__n & (1 << 1)) {
		*d++ = *s++;
		*d++ = *s++;
	}

	if (__n & 1)
		*d++ = *s++;

	return __dest;
}

void *memset(void *__src, int __c, size_t __n)
{
	int i;
	unsigned char *s = __src;
	unsigned char c = (unsigned char)__c;
	
	for(i = (__n >> 3); i > 0; i--){
		*s++ = c;
		*s++ = c;
		*s++ = c;
		*s++ = c;
		*s++ = c;
		*s++ = c;
		*s++ = c;
		*s++ = c;
	}
	
	if(__n & (1 << 2)){
        	*s++ = c;
		*s++ = c;
		*s++ = c;
		*s++ = c;
	}
	
	if(__n & (1 << 1)){
		*s++ = c;
		*s++ = c;
	}
	
	if(__n & 1)
        	*s++ = c;

	return __src;
}

