#ifndef _HERMIT_ETH_EP93XX_H_
#define _HERMIT_ETH_EP93XX_H_

// Length define
#define LEN_QueRxDesc 32
#define LEN_QueRxSts  LEN_QueRxDesc
#define LEN_QueTxDesc 8
#define LEN_QueTxSts  LEN_QueTxDesc

typedef struct _RxDescriptor{
  unsigned long ba:32,
                bl:16,
                bi:15,
                nsof:1;
}RxDescriptor;

typedef struct _RxStatus{
  unsigned long rsrv1:8,
    hti:6,
    rsrv2:1,
    crci:1,
    crce:1,
    edata:1,
    runt:1,
    fe:1,
    oe:1,
    rxerr:1,
    am:2,
    rsrv3:4,
    eob:1,
    eof:1,
    rwe:1,
    rfp1:1,
    fl:16,
    bi:15,
    rfp2:1;
}RxStatus;
typedef struct _TxDescriptor{
  unsigned long ba:32,
    bl:12,
    resv1:3,
    af:1,
    bi:15,
    eof:1;
}TxDescriptor;
typedef struct _TxStatus{
  unsigned long bi:15,
    rsrv1:1,
    ncoll:5,
    rsrv2:3,
    ecoll:1,
    txu:1,
    ow:1,
    rsrv3:1,
    lcrs:1,
    fa:1,
    txwe:1,
    txfp:1;
}TxStatus;

typedef struct _ep93xxEth_info{
  //Queue
  RxDescriptor QueRxDesc[LEN_QueRxDesc];
  RxStatus     QueRxSts[LEN_QueRxSts];
  TxDescriptor QueTxDesc[LEN_QueTxDesc];
  TxStatus     QueTxSts[LEN_QueTxSts];

  int idxQueRxDesc;
  int idxQueRxSts;
  int idxQueTxDesc;
  int idxQueTxSts;

}ep93xxEth_info;

void ep93xx_enable_phy_module(void);
void ep93xx_disable_phy_module(void);

int ep93xx_eth_send(const eth_frame *ethfr,
		    const void *pfr, const unsigned int pfrlen);
int ep93xx_eth_recv(const unsigned char *mac, eth_frame **ethfr,
		    void **pbuf, unsigned int *pbuflen, int *timeout);
int ep93xx_eth_rxbuf_free(const int idx);

int ep93xx_eth_init(const unsigned char *mac);


#endif
