/*
 * Copyright (c) 2007 Atmark Techno, Inc.  All Rights Reserved.
 */

#include <target/buffer.h>
#include <target/crc.h>
#include <target/io.h>
#include <target/flash.h>
#include <target/frob.h>
#include <target/medium.h>
#include <mx3/ioregs.h>
#include "linux.h"
#include "memregions.h"
#include "board.h"
#include <target/param.h>
#include <target/gunzip.h>
#include <target/net/mac.h>
#include "tftpdl.h"

extern const command_t *__command_list_start;
extern const abbrev_t *__command_abbrev_start;

static const command_t **commands = &__command_list_start;
static const abbrev_t **abbrevs = &__command_abbrev_start;

/****************************************************************************
 * common command entry
 ****************************************************************************/
COMMAND_ABBR(help_command, '?');
COMMAND_ABBR(version_command, 'V');
COMMAND(upload_command);
COMMAND(download_command);
COMMAND(jump_command);

/****************************************************************************
 *
 ****************************************************************************/
#define print_version() ((*version_command.func)(0, 0))

#define hermit_command_loop()                                           \
({                                                                      \
	command_list_t command_list = {commands, abbrevs, "hermit", 0}; \
	do_command_loop(&command_list);                                 \
	for(;;);                                                        \
})

/****************************************************************************
 * hermit main
 ****************************************************************************/
int hmain(void)
{
	/* initialize */
	board_init();

	init_crc32();

	print_version();

	if (is_autoboot_mode())
		autoboot();

	led_off();

	hermit_command_loop();
}


