#include <target/mmu.h>
#include "memregions.h"
#include "linux.h"

void boost_on(int mode)
{
    const unsigned int offset = LINUX_LOAD_ADDRESS - 0x4000;
    unsigned int i;
    switch(mode){
    case BOOST_ETH_MODE:
      for (i = 0x0; i < 0x3000; i += 0x4) {
	*(volatile unsigned int *)(offset + i) = (i << 18) + 0xc12;
      }
      for (       ; i < 0x3120; i += 0x4) {
	*(volatile unsigned int *)(offset + i) = (i << 18) + 0xc1e;
      }
      for (       ; i < 0x3130; i += 0x4) {
	*(volatile unsigned int *)(offset + i) = (i << 18) + 0xc12;
      }
      for (       ; i < 0x3400; i += 0x4) {
	*(volatile unsigned int *)(offset + i) = (i << 18) + 0xc1e;
      }
      for (       ; i < 0x4000; i += 0x4) {
	*(volatile unsigned int *)(offset + i) = (i << 18) + 0xc12;
      }
      break;
    case BOOST_LINUX_MODE:
    default:
      for (i = 0x0; i < 0x2000; i += 0x4) {
	*(volatile unsigned int *)(offset + i) = (i << 18) + 0xc1e;
      }
      for (       ; i < 0x2400; i += 0x4) {
	*(volatile unsigned int *)(offset + i) = (i << 18) + 0xc12;
      }
      for (       ; i < 0x4000; i += 0x4) {
	*(volatile unsigned int *)(offset + i) = (i << 18) + 0xc1e;
      }
      break;
    }

    __asm__ volatile (
		      "    mov     r0, #0                  \n"
		      "    mcr     p15, 0, r0, c7, c7      \n"
		      "    mcr     p15, 0, r0, c7, c10, 4  \n"
		      "    mcr     p15, 0, r0, c8, c7      \n"
		      "    mov     r0, #0xc0000000         \n"
		      "    add     r0, r0, #0x14000        \n"
		      "    mcr     p15, 0, r0, c2, c0      \n"
		      "    mov     r0, #0x1f               \n"
		      "    mcr     p15, 0, r0, c3, c0      \n"
		      "    mrc     p15, 0, r0, c1, c0      \n"
		      "    orr     r0, r0, #0x0035         \n"
		      "    orr     r0, r0, #0x3100         \n"
		      "    mcr     p15, 0, r0, c1, c0      \n"
		      );
}

void boost_off (void)
{
    __asm__ volatile (
		      "    mov     r1, #7 << 5             \n"
                      "1:  orr     r0, r1, #63 << 26       \n"
		      "2:  mcr     p15, 0, r0, c7, c14, 2  \n"
		      "    subs    r0, r0, #1 << 26        \n"
		      "    bcs     2b                      \n"
		      "    subs    r1, r1, #1 << 5         \n"
                      "    bcs     1b                      \n"
                      "    mov     r0, #0                  \n"
		      "    mcr     p15, 0, r0, c7, c5, 0   \n"
		      "    mcr     p15, 0, r0, c7, c10, 4  \n"
		      "    mrc     p15, 0, r0, c1, c0      \n"
		      "    bic     r0, r0, #0x0035         \n"
		      "    bic     r0, r0, #0x3100         \n"
		      "    mcr     p15, 0, r0, c1, c0      \n"
		      );
}
