
#ifndef _HERMIT_UDP_H_
#define _HERMIT_UDP_H_

typedef struct _ip_pseudo_header{
  unsigned char dst_ipaddr[4];
  unsigned char src_ipaddr[4];
  unsigned char zero;
  unsigned char protocol;
  unsigned short data_len;
}ip_pseudo_header;

typedef struct _udp_frame{
  unsigned short src_port;
  unsigned short dst_port;
  unsigned short data_len;
  unsigned short checksum;
}udp_frame;

int udp_send(const unsigned char *dst_ipaddr,
	     const unsigned short dst_port,
	     const unsigned short src_port,
	     const void *pbuf, const unsigned int pbuflen);
int udp_proc(const unsigned char *src_ipaddr,
	     const unsigned short dst_port, unsigned short *src_port,
	     void **pbuf, unsigned int *pbuflen);
#endif
