#!/bin/sh
#
# depend.sh: build dependency information.
#

# exit on error
set -e

SOURCE=$1
DEPFILE=$2
DEPFILETMP=`echo $2 | sed "s/\//@o@/g"`
shift; shift

# use gcc as compiler if not provided by make
[ "$CC" ] || CC=gcc

# use GCC with C flags to generate dependencies; replace target foo.o
# with 'foo.o foo.d' so that dependency file will have the same
# dependencies as its object file.

$CC -M $* $SOURCE | sed "s/\(.*\)\.o[ :]*/\1.o $DEPFILETMP : /g" | sed "s/@o@/\//g" > $DEPFILE

# remove depfile if empty (b/c of error)
[ -s $DEPFILE ] || rm -f $DEPFILE

