﻿/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.objects.characters {
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	
	import jp.sourceforge.aramaki.net.Network;
	import jp.sourceforge.aramaki.utils.toRadian;
	
	public class MyCharacter extends Character {
		/**
		 * @private
		 */
		private static var _instance:MyCharacter;
		/**
		 * 位置変更フラグ
		 */
		private var positionChanged:Boolean = false;
		/**
		 * 位置送信タイマー
		 */
		private var positionChangeTimer:Timer;
		/**
		 * 向き
		 */
		public var direction:int;
		/**
		 * ネットワーク
		 */
		private var network:Network;
		
		/**
		 * @param network ネットワーク
		 */
		public function MyCharacter(network:Network) {
			//singleton
			if (_instance) throw new ArgumentError("getInstance()を使用してください");
			
			this.network = network;
			
			//TODO useHandCursor = true;
			
			//100ms ごとに位置が送信されているかどうかチェック
			positionChangeTimer = new Timer(100);
			positionChangeTimer.addEventListener(TimerEvent.TIMER, onPositionChangeTimer);
			positionChangeTimer.start();
		}
		
		/**
		 * @inheritDoc
		 */
		override public function destroy():void {
			//位置送信タイマーをとめる
			positionChangeTimer.reset();
			positionChangeTimer.stop();
			
			super.destroy();
		}
		
		/**
		 * インスタンスを作成
		 */
		public static function createInstance(network:Network):MyCharacter {
			_instance = new MyCharacter(network);
			return _instance;
		}
		
		/**
		 * インスタンスを削除
		 */
		public static function destroyInstance():void {
			_instance.destroy();
			_instance = null;
		}
		
		/**
		 * インスタンス
		 */
		public static function get instance():MyCharacter {
			return _instance;
		}
		
		/**
		 * @inheritDoc
		 */
		override public function set userName(name:String):void {
			super.userName = name;
			network.sendToGroup("setName", userName);
		}
		
		/**
		 * @inheritDoc
		 */
		override public function set message(message:String):void {
			super.message = message;
			network.sendToGroup("setMessage", message);
		}
		
		/**
		 * @inheritDoc
		 */
		override public function set x(x:Number):void {
			super.x = x;
			positionChanged = true;
		}
		
		/**
		 * @inheritDoc
		 */
		override public function set y(y:Number):void {
			super.y = y;
			positionChanged = true;
		}
		
		/**
		 * @inheritDoc
		 */
		override public function set z(z:Number):void {
			super.z = z;
			positionChanged = true;
		}
		
		/**
		 * @inheritDoc
		 */
		override public function set characterId(value:int):void {
			super.characterId=value;
			network.sendToGroup("setCharacter",value);
		}
		
		/**
		 * 前進
		 */
		public function goAhead():void {
			x += Math.sin(toRadian(direction)) * 9.375;
			z += Math.cos(toRadian(direction)) * 9.375;
		}
		
		/**
		 * 後退
		 */
		public function goBack():void {
			x -= Math.sin(toRadian(direction)) * 9.375;
			z -= Math.cos(toRadian(direction)) * 9.375;
		}
		
		/**
		 * 左旋回
		 */
		public function turnLeft():void {
			direction = (direction - 5) % 360;
		}
		
		/**
		 * 右旋回
		 */
		public function turnRight():void {
			direction = (direction + 5) % 360;
		}
		
		/**
		 * 位置送信タイマーイベントハンドラ
		 * 
		 * 位置が変更されていたら送信
		 */
		public function onPositionChangeTimer(event:TimerEvent):void {
			if (positionChanged) {
				network.sendToGroup("move", x, y, z);
				positionChanged = false;
			}
		}
	}
}