﻿/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.objects.characters {
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	import jp.sourceforge.aramaki.controls.Balloon;
	import jp.sourceforge.aramaki.controls.ChatTab;
	
	import mx.core.BitmapAsset;
	import mx.core.SoundAsset;
	
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.materials.MovieMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	
	/**
	 * 映像配信中マーククリックイベント
	 */
	[Event(name="receiveVideo",type="flash.events.Event")]
	
	/**
	 * 音声配信中マーククリックイベント
	 */
	[Event(name="receiveAudio",type="flash.events.Event")]
	
	public class Character extends DisplayObject3D {
		/**
		 * 荒巻スカルチノフ
		 */
		[Embed(source='../characters/aramaki.png')]
		static private var AramakiImage:Class;
		/**
		 * 荒巻スカルチノフ(布団)
		 */
		[Embed(source='../characters/aramaki_with_futon.png')]
		static private var AramakiWithFutonImage:Class;
		/**
		 * 荒巻スカルチノフ(ﾌﾞﾜｯ)
		 */
		[Embed(source='../characters/aramaki_buwa.png')]
		static private var AramakiBuwa:Class;
		/**
		 * @private
		 */
		[ArrayElementType("Class")]
		static private var _characterImages:Array=[
			AramakiImage,
			AramakiWithFutonImage,
			AramakiBuwa
		];
		/**
		 * @private
		 */
		[ArrayElementType("String")]
		static private var _characterNames:Array=[
			"荒巻スカルチノフ",
			"荒巻スカルチノフ (布団)",
			"荒巻スカルチノフ (ﾌﾞﾜｯ)"
		];
		/**
		 * テクスチャ
		 */
		private var texture:Sprite=new Sprite;
		/**
		 * 板ポリゴン
		 */
		private var plane:Plane;
		/**
		 * キャラクター画像
		 */
		private var image:DisplayObject;
		/**
		 * 名前
		 */
		private var nameText:TextField=new TextField;
		/**
		 * ふきだし
		 */
		private var balloon:Balloon=new Balloon;
		/**
		 * ログイン音
		 */
		[Embed(source = '../sounds/login.mp3')]
		private static var LoginSound:Class;
		private static var loginSound:SoundAsset=new LoginSound;
		/**
		 * 発言音
		 */
		[Embed(source = '../sounds/say.mp3')]
		private static var SaySound:Class;
		private static var saySound:SoundAsset=new SaySound;
		/**
		 * ログアウト音
		 */
		[Embed(source = '../sounds/logout.mp3')]
		private static var LogoutSound:Class;
		private static var logoutSound:SoundAsset=new LogoutSound;
		/**
		 * 効果音有効フラグ
		 */
		public static var enableSound:Boolean=false;
		/**
		 * 板ポリゴンのマテリアル
		 */
		private var movieMaterial:MovieMaterial;
		/**
		 * @private
		 */
		private var _characterId:int=0;
		/**
		 * 影
		 */
		[Embed(source = '../characters/shadow.png')]
		private static var ShadowImage:Class;
		private static var shadowImage:BitmapAsset=new ShadowImage;
		/**
		 * 映像配信中マーク画像
		 */
		[Embed(source='../characters/videomark.png')]
		private static var VideoMarkImageClass:Class;
		private static var videoMarkImage:BitmapAsset=new VideoMarkImageClass;
		/**
		 * 音声配信中マーク画像
		 */
		[Embed(source='../characters/audiomark.png')]
		private static var AudioMarkImageClass:Class;
		private static var audioMarkImage:BitmapAsset=new AudioMarkImageClass;
		/**
		 * 映像配信中マークマテリアル
		 */
		private static var videoMarkMaterial:BitmapMaterial=new BitmapMaterial(videoMarkImage.bitmapData);
		/**
		 * 音声配信中マークマテリアル
		 */
		private static var audioMarkMaterial:BitmapMaterial=new BitmapMaterial(audioMarkImage.bitmapData);
		
		/**
		 * 映像配信中マーク
		 */
		private var videoMark:Plane=new Plane(videoMarkMaterial);
		/**
		 * 音声配信中マーク
		 */
		private var audioMark:Plane=new Plane(audioMarkMaterial);
		
		/**
		 * もちろんコンストラクタ
		 */
		public function Character() {
			nameText.defaultTextFormat=new TextFormat("MS PGothic",12,0x0000ff,true);
			nameText.y=-19;
			nameText.autoSize=TextFieldAutoSize.LEFT;
			texture.addChild(nameText);
			
			balloon.y=-22;
			texture.addChild(balloon);
			
			image=new characterImages[0];
			image.y=0;
			image.x=-image.width/2;
			texture.addChild(image);
			
			movieMaterial=new MovieMaterial(texture,true,true);
			
			createPlane();
			
			var shadowPlane:Plane=new Plane(new BitmapMaterial(shadowImage.bitmapData));
			shadowPlane.rotationX=-90;
			shadowPlane.y=10;
			addChild(shadowPlane);
			
			videoMarkMaterial.interactive=true;
			
			videoMark.x=63;
			videoMark.y=42;
			videoMark.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK,clickVideoMarkHandler);
			videoMark.visible=false;
			addChild(videoMark);
			
			audioMarkMaterial.interactive=true;
			
			audioMark.x=63;
			audioMark.y=21;
			audioMark.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK,clickAudioMarkHandler);
			audioMark.visible=false;
			addChild(audioMark);
			
			if (enableSound) loginSound.play();
		}
		
		/**
		 * 後始末
		 */
		public function destroy():void {
			if (enableSound) logoutSound.play();
		}
		
		/**
		 * 名前
		 */
		public function get userName():String {
			return nameText.text;
		}
		
		/**
		 * @private
		 */
		public function set userName(name:String):void {
			nameText.text=name;
			nameText.x=-nameText.width/2;
			
			movieMaterial.drawBitmap();
			createPlane();
		}
		
		/**
		 * 発言内容
		 */
		public function get message():String {
			return balloon.text;
		}
		
		/**
		 * @private
		 */
		public function set message(message:String):void {
			if (message.length) {
				ChatTab.instance.appendLog(nameText.text,message);
				if (enableSound) saySound.play();
			}
			
			balloon.text=message;
			
			movieMaterial.drawBitmap();
			createPlane();
		}
		
		/**
		 * 板を再作成
		 */
		private function createPlane():void {
			if (plane) removeChild(plane);
			plane=new Plane(movieMaterial,texture.width,texture.height);
			plane.x=0;
			plane.y=texture.height/2+10;
			addChild(plane);
		}
		
		/**
		 * キャラクターID
		 */
		public function get characterId():int {
			return _characterId;
		}
		
		/**
		 * @private
		 */
		public function set characterId(value:int):void {
			_characterId=value;
			
			texture.removeChild(image);
			
			image=new characterImages[value];
			image.y=0;
			image.x-=image.width/2;
			texture.addChild(image);
			
			movieMaterial.drawBitmap();
			createPlane();
		}
		
		/**
		 * キャラクター画像配列
		 */
		static public function get characterImages():Array {
			return _characterImages;
		}
		
		/**
		 * キャラクター名配列
		 */
		static public function get characterNames():Array {
			return _characterNames;
		}
		
		/**
		 * 音声配信中マークがクリックされた
		 */
		private function clickAudioMarkHandler(event:InteractiveScene3DEvent):void {
			dispatchEvent(new Event("receiveAudio"));
		}
		
		/**
		 * 映像受信中マークがクリックされた
		 */
		private function clickVideoMarkHandler(event:InteractiveScene3DEvent):void {
			dispatchEvent(new Event("receiveVideo"));
		}
		
		/**
		 * 音声配信中フラグ
		 */
		public function get audioPublishing():Boolean {
			return audioMark.visible;
		}
		
		/**
		 * @private
		 */
		public function set audioPublishing(value:Boolean):void {
			audioMark.visible=value;
		}
		
		/**
		 * 映像配信中フラグ
		 */
		public function get videoPublishing():Boolean {
			return videoMark.visible;
		}
		
		/**
		 * @private
		 */
		public function set videoPublishing(value:Boolean):void {
			videoMark.visible=value;
		}
	}
}