/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.events {
	import flash.events.Event;
	import flash.media.Microphone;

	public class AudioPublishStartEvent extends Event {
		/**
		 * 音声配信開始
		 */
		public static const AUDIO_START:String="audioStart";
		/**
		 * @private
		 */
		private var _microphone:Microphone;
		
		/**
		 * @param microphone マイク
		 */
		public function AudioPublishStartEvent(type:String,bubbles:Boolean=false,cancelable:Boolean=false,microphone:Microphone=null) {
			super(type,bubbles,cancelable);
			_microphone=microphone;
		}
		
		/**
		 * マイク
		 */
		public function get microphone():Microphone {
			return _microphone;
		}
		
		/**
		 * @inheritDoc
		 */
		public override function clone():Event {
			return new AudioPublishStartEvent(type,bubbles,cancelable,_microphone);
		}
		
		/**
		 * @inheritDoc
		 */
		public override function toString():String {
			return formatToString("AudioPublishStartEvent","type","bubbles","cancelable","eventPhase","_microphone"); 
		}
	}
}