/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.controls {
	import caurina.transitions.Tweener;
	
	import flash.display.Graphics;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	
	import mx.controls.Label;

	/**
	 * ブロードキャストメッセージ表示クラス
	 */
	public class BroadcastText extends Label {
		/**
		 * タイマー
		 * 
		 * 始動されてから10秒後にメッセージを隠す
		 */
		private var hideTimer:Timer=new Timer(10000,1);
		
		/** 
		 * 初期化
		 */
		public function BroadcastText() {
			super();
			
			alpha=0;
			
			hideTimer.addEventListener(TimerEvent.TIMER,hide);
		}
		
		/**
		 * メッセージをセットし表示した後タイマーを始動
		 * 
		 * @param value メッセージ
		 */
		override public function set text(value:String):void {
			super.text=value;
			
			hideTimer.stop();
			hideTimer.reset();
			hideTimer.start();
			
			if (alpha==0) y=-height;
			Tweener.addTween(this,{y:0,alpha:1,time:0.5});
		}
		
		/**
		 * ブロードキャストメッセージを隠す
		 */
		private function hide(event:TimerEvent):void {
			Tweener.addTween(this,{y:-height,alpha:0,time:0.5});
		}
		
		/**
		 * @inheritDoc
		 * 
		 * 枠と背景を描画
		 */
		override protected function updateDisplayList(unscaledWidth:Number,unscaledHeight:Number):void {
			super.updateDisplayList(unscaledWidth,unscaledHeight);
			
			trace("unscaled: w:"+unscaledWidth+"h:"+unscaledHeight);
			drawRoundRect(0,0,unscaledWidth,unscaledHeight,null,[0xffffff,0xcccccc],1,verticalGradientMatrix(0,0,unscaledWidth,unscaledHeight),"linear");
			
			var g:Graphics=graphics;
			g.lineStyle(1,0xb7babc);
			g.moveTo(0,0);
			g.lineTo(unscaledWidth,0);
			g.lineTo(unscaledWidth,unscaledHeight);
			g.lineTo(0,unscaledHeight);
		}
	}
}