/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.controls {
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;

	public class Balloon extends Sprite {
		/**
		 * 最大幅
		 */
		private const MAX_WIDTH:int=280;
		/**
		 * テキストフィールド
		 */
		private var textField:TextField=new TextField;
		
		/**
		 * コンストラクタ
		 */
		public function Balloon() {
			super();
			
			textField.defaultTextFormat=new TextFormat("MS PGothic",12);
			textField.background=true;
			
			addChild(textField);
			
			//ふきだしの下部を描画
			var g:Graphics=graphics;
			g.beginFill(0xffffff);
			g.lineTo(-6,-12);
			g.lineTo(6,-12);
			g.lineTo(0,0);
			g.endFill();
			
			visible=false;
		}
		
		/**
		 * 表示内容
		 */
		public function get text():String {
			return textField.text;
		}
		
		/**
		 * @private
		 */
		public function set text(value:String):void {
			textField.text=value;
			
			if (textField.width>MAX_WIDTH) {
				textField.wordWrap=true;
				textField.width=280;
			} else {
				textField.wordWrap=false;
				textField.autoSize=TextFieldAutoSize.LEFT;
			}
			
			textField.x=-textField.width/2;
			textField.y=-textField.height-12;
			
			visible=value.length!=0;
		}
	}
}