/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

import flash.display.StageQuality;
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.ui.Keyboard;

import jp.sourceforge.aramaki.events.AudioPublishStartEvent;
import jp.sourceforge.aramaki.events.MessageEvent;
import jp.sourceforge.aramaki.events.PeerChangeGroupEvent;
import jp.sourceforge.aramaki.events.PeerEvent;
import jp.sourceforge.aramaki.events.VideoPublishStartEvent;
import jp.sourceforge.aramaki.net.Peer;
import jp.sourceforge.aramaki.objects.characters.Character;
import jp.sourceforge.aramaki.objects.characters.MyCharacter;
import jp.sourceforge.aramaki.utils.KeyState;
import jp.sourceforge.aramaki.utils.toRadian;

import mx.core.SoundAsset;

import org.papervision3d.cameras.Camera3D;
import org.papervision3d.materials.ColorMaterial;
import org.papervision3d.objects.primitives.Plane;

/**
 * キー状態管理クラス
 */
private var keyState:KeyState;
/**
 * キャラクター
 */
private var characters:Object=new Object;
/**
 * ブロードキャストを受信したときの効果音
 */
[Embed(source='../sounds/broadcast.mp3')]
private var BroadcastSound:Class;
private var broadcastSound:SoundAsset=new BroadcastSound;

/**
 * 初期化
 * 
 * 画質を低に設定し、
 * Networkのコールバックオブジェクトにハンドラを登録
 */
private function init():void {
	stage.quality = StageQuality.LOW;
	
	keyState = new KeyState(this);
	
	network.client={
		move:peerMoveHandler,
		setName:peerSetNameHandler,
		setMessage:peerSetMessageHandler,
		broadcast:peerBroadcastHandler,
		setCharacter:peerSetCharacterHandler,
		setAudioPublishStatus:peerSetAudioPublishStatusHandler,
		setVideoPublishStatus:peerSetVideoPublishStatusHandler
	};
}

/**
 * キャラクターセレクタの作成が完了
 * 
 * キャラクターを登録
 */
private function characterSelectorCreationComplete():void {
	var names:Array=Character.characterNames;
	var images:Array=Character.characterImages;
	var num:int=names.length;
	var dp:Array=new Array(num);
	
	for (var i:int=0;i<num;i++) dp[i]={label:names[i],icon:images[i]};
	
	characterSelector.dataProvider=dp;
}

/**
 * @inheritDoc
 */
override protected function keyDownHandler(event:KeyboardEvent):void {
	//カーソルキーでスクロールさせない
	if (event.keyCode!=Keyboard.DOWN&&event.keyCode!=event.keyCode==Keyboard.UP&&event.keyCode==Keyboard.RIGHT&&event.keyCode==Keyboard.LEFT) {
		super.keyDownHandler(event);
	}
} 

/**
 * ブロードキャスト
 */
private function chatTabBroadcastHandler(event:MessageEvent):void {
	var name:String=MyCharacter.instance.userName;
	
	network.sendToAll("broadcast",name,event.message);
	peerBroadcastHandler(null,name,event.message);
}

/**
 * ログインボタンが押された
 */
private function loginHandler():void {
	loginPanel.loginButtonEnabled=false;
	loginPanel.status="ネットワークに接続しています...";
	
	//ネットワークに接続
	network.connect();
}

/**
 * ENTER_FRAMEハンドラ
 * 
 * 発言内容入力欄にフォーカスがセットされている場合
 */
private function enterFrameHandler(event:Event):void {
	if (!chatTab.inputting) {
		var mc:MyCharacter = MyCharacter.instance;
		var mf:Boolean = false;
		
		if (keyState.isDown(Keyboard.UP)) {
			//前進
			mc.goAhead();
			
			mf = true;
		}
		
		if (keyState.isDown(Keyboard.RIGHT)) {
			//右旋回
			mc.turnRight();
			
			mf = true;
		}
		
		if (keyState.isDown(Keyboard.LEFT)) {
			//左旋回
			mc.turnLeft();
			
			mf = true;
		}
		
		if (keyState.isDown(Keyboard.DOWN)) {
			//後退
			mc.goBack();
			
			mf = true;
		}
		
		if (mf) setCameraPos();
	}
	
	//レンダリング
	pv3d.renderScene();
}

/**
 * ネットワークに接続完了
 * 
 * メイン画面に切り替え、メイン画面が作成されるまで待つ
 */
private function connectCompleteHandler():void {
	view.selectedIndex=1;
	
	callLater(login);
}

/**
 * ログイン
 */
private function login():void {
	if (characterSelector) characterSelector.selectedIndex=0;
	
	var m:MyCharacter;
	m=MyCharacter.createInstance(network);
	m.userName=loginPanel.userName;
	m.message = "";
	m.x = 0;
	m.y = 0;
	m.z = 0;
	m.direction = 0;
	
	setCameraPos();
	
	pv3d.scene.addChild(m);
	
	//temp
	var p:Plane = new Plane(new ColorMaterial(0x7f7f7f, 1, false), 200, 200);
	p.rotationX = -90;
	p.x = 100;
	p.y = 0;
	p.z = 100;
	pv3d.scene.addChild(p,"plane");
	
	addEventListener(Event.ENTER_FRAME, enterFrameHandler);
}

/**
 * ネットワークから切断
 * 
 * 自機を削除し、ログイン画面に切り替える
 */
private function connectClosingHandler():void {
	removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
	
	broadcastTab.resetPublishStatus();
	
	//temp
	pv3d.scene.removeChildByName("plane");
	
	pv3d.scene.removeChild(MyCharacter.instance);
	MyCharacter.destroyInstance();
	
	loginPanel.status="ログアウトしています...";
	view.selectedIndex=0;
}

/**
 * ネットワークから切断完了
 * 
 * ログインボタンを有効にする
 */
private function connectClosedHandler():void {
	loginPanel.status="";
	loginPanel.loginButtonEnabled=true;
}

/**
 * ネットワークへの接続に失敗
 */
private function connectFailedHandler():void {
	loginPanel.status = "接続に失敗しました。";
	loginPanel.loginButtonEnabled=true;
}

/**
 * ピアが接続してきた
 */
private function peerConnectHandler(event:PeerEvent):void {
	trace("PeerConnect: "+event.peer.farID);
}

/**
 * ピアが所属グループを変更した
 * 
 * ピアと所属グループが同じでかつキャラクターが存在しない場合キャラクターを作成
 * ピアと所属グループが違いかつキャラクターが存在する場合キャラクターを削除
 */
private function peerChangeGroup(event:PeerChangeGroupEvent):void {
	var peer:Peer=event.peer;
	var id:String=peer.farID;
	var group:String=event.group;
	var c:Character=characters[id];
	
	trace("PeerChangeGroup: "+id+","+group);
	
	if ((group==network.group)&&(!c)) {
		var mc:MyCharacter=MyCharacter.instance;
		
		c=new Character;
		pv3d.scene.addChild(c);
		characters[id]=c;
		setCameraPos();
		
		peer.send("setName",mc.userName);
		peer.send("setMessage",mc.message);
		peer.send("move",mc.x,mc.y,mc.z);
		peer.send("setCharacter",mc.characterId);
		peer.send("setVideoPublishStatus",broadcastTab.publishingVideo);
		peer.send("setAudioPublishStatus",broadcastTab.publishingAudio);
	} else if ((group!=network.group)&&c) {
		c.destroy();
		pv3d.scene.removeChild(c);
		characters[id]=null;
	}
}

/**
 * ピアが切断した
 * 
 * キャラクターが存在する場合削除
 */
private function peerClose(event:PeerEvent):void {
	var id:String=event.peer.farID;
	var c:Character=characters[id];
	
	trace("PeerClose: "+id);
	
	if (c) {
		c.destroy();
		pv3d.scene.removeChild(c);
		delete characters[id];
	}
}

/**
 * ピアが移動した
 * 
 * @param peer ピア
 * @param x キャラクターのX座標
 * @param y キャラクターのY座標
 * @param z キャラクターのZ座標
 */
private function peerMoveHandler(peer:Peer,x:Number,y:Number,z:Number):void {
	trace("PeerMove: "+peer.farID+","+x+","+y+","+z);
	
	var c:Character=characters[peer.farID];
	c.x=x;
	c.y=y;
	c.z=z;
}

/**
 * ピアが名前を変更した
 * 
 * @param peer ピア
 * @param name キャラクターの名前
 */
private function peerSetNameHandler(peer:Peer,name:String):void {
	trace("PeerSetName: "+peer.farID+","+name);
	
	characters[peer.farID].userName=name;
}

/**
 * ピアが発言した
 * 
 * @param peer ピア
 * @param message 発言内容
 */
private function peerSetMessageHandler(peer:Peer,message:String):void {
	trace("PeerSetMessage: "+peer.farID+","+message);
	
	characters[peer.farID].message=message;
}

/**
 * ブロードキャストを受信した
 * 
 * メッセージをログに記録し、画面上部に表示
 * 
 * @param peer ピア
 * @param name 送信者の名前
 * @param message 放送内容
 */
private function peerBroadcastHandler(peer:Peer,name:String,message:String):void {
	trace("broadcast: "+name+","+message);
	
	chatTab.appendLog("(broadcast) "+name,message);
	broadcastText.text=name+"："+message;
	
	if (Character.enableSound) broadcastSound.play();
}

/**
 * ピアがキャラクターを変更した
 * 
 * @param peer ピア
 * @param characterId キャラクターのID
 */
private function peerSetCharacterHandler(peer:Peer,characterId:int):void {
	trace("peerChangeCharacter: "+peer.farID+","+characterId);
	
	characters[peer.farID].characterId=characterId;
}

/**
 * ピアが音声配信状態を変更した
 * 
 * @param peer ピア
 * @param publishing 状態
 */
private function peerSetAudioPublishStatusHandler(peer:Peer,publishing:Boolean):void {
	characters[peer.farID].audioPublishing=publishing;
}

/**
 * ピアが映像配信状態を変更した
 * 
 * @param peer ピア
 * @param publishing 状態
 */
private function peerSetVideoPublishStatusHandler(peer:Peer,publishing:Boolean):void {
	characters[peer.farID].videoPublishing=publishing;
}

/**
 * カメラの位置を設定
 */
private function setCameraPos():void {
	var mc:MyCharacter = MyCharacter.instance;
	
	//自機に合わせてカメラを移動
	var camera:Camera3D=pv3d.camera;
	camera.x = mc.x - Math.sin(toRadian(mc.direction)) * 1000;
	camera.y = mc.y + 150;
	camera.z = mc.z - Math.cos(toRadian(mc.direction)) * 1000;
	camera.target.x = mc.x;
	camera.target.y = mc.y + 50;
	camera.target.z = mc.z;
	
	//自機が移動した
	//ビルボード表示
	mc.rotationY = mc.direction;
	
	for each(var character:Character in characters) character.rotationY=mc.direction;
}

/**
 * 映像配信を開始
 */
private function startVideoPublishHandler(event:VideoPublishStartEvent):void {
	MyCharacter.instance.videoPublishing=true;
	network.sendToGroup("setVideoPublishStatus",true);
}

/**
 * 音声配信を開始
 */
private function startAudioPublishHandler(event:AudioPublishStartEvent):void {
	MyCharacter.instance.audioPublishing=true;
	network.sendToGroup("setAudioPublishStatus",true);
}

/**
 * 映像配信を終了
 */
private function stopVideoPublishHandler():void {
	MyCharacter.instance.videoPublishing=false;
	network.sendToGroup("setVideoPublishStatus",false);
}

/**
 * 音声配信を終了
 */
private function stopAudioPublishHandler():void {
	MyCharacter.instance.audioPublishing=false;
	network.sendToGroup("setAudioPublishStatus",false);
}
