/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WORLD_H_
#define WORLD_H_

#include "P2PNetwork.h"
#include "Model.h"
#include "Map.h"

class World {
	//singleton
	static World *instance;

	P2PNetwork *network;
	//空
	Model *sky;

	Map *map;

	World(const wxString &name,uint16_t listenPort,const wxString &bootstrapScriptUrl);
	~World();
public:
	//描画
	void render() const;

	inline bool isError() const {
		return network->isError();
	}

	//singleton
	static inline bool login(const wxString &name,uint16_t listenPort,const wxString &bootstrapScriptUrl) {
		World *world=new World(name,listenPort,bootstrapScriptUrl);

		if (world->isError()) {
			//ログイン失敗
			delete instance;

			return false;
		} else {
			instance=world;
			return true;
		}
	}

	static inline World &getInstance() {
		return *instance;
	}

	static inline void logout() {
		delete instance;
		instance=NULL;
	}

	static inline bool isLoggingIn() {
		return instance!=NULL;
	}
};

#endif /* WORLD_H_ */
