/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "World.h"
#include "MyCharacter.h"

World *World::instance;

World::World(const wxString &name,uint16_t listenPort,const wxString &bootstrapScriptUrl) {
	//ネットワークに接続
	network=new P2PNetwork(listenPort,bootstrapScriptUrl);

	//空モデルをロード
	sky=new Model(wxT("sky.obj"));

	//初期マップをロード
	map=new Map(wxT("entrance_area.xml"));

	MyCharacter::createInstance(*map,*network);

	if (network->isError()) return;

	//初期位置を設定
	MyCharacter::getInstance().setPosition(Point3d(0,0,0));

	//名前を設定
	MyCharacter::getInstance().setName(name);

	network->ready();
}

World::~World() {
	delete network;
	MyCharacter::destroyInstance();
	delete map;
	delete sky;
}

void World::render() const {
	glLoadIdentity();

	//自機に合わせて物をずらす
	glRotated(MyCharacter::getInstance().getDirection(),0,1,0);
	glTranslated(-MyCharacter::getInstance().getPosition().x,-MyCharacter::getInstance().getPosition().y,-MyCharacter::getInstance().getPosition().z);

	//自機を描画
	MyCharacter::getInstance().render();

	//ほかのキャラクタを描画
	network->renderCharacter();

	//空を描画
	glPushMatrix();
	//自機の動きにあわせてずらす
	glTranslated(MyCharacter::getInstance().getPosition().x,MyCharacter::getInstance().getPosition().y,MyCharacter::getInstance().getPosition().z);

	sky->render();

	glPopMatrix();

	//マップを描画
	map->render();
}
