/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "MainFrame.h"
#include "AramakiOnline.h"
#include "LoginDialog.h"
#include "World.h"
#include "MyCharacter.h"

#if !defined(__WXMSW__)&&!defined(__WXPM__)
//Win32/OS2以外のOS用アイコン
#include "aramakiIcon.xpm"
#endif

MainFrame::MainFrame() : MainFrameBase(NULL) {
	//アイコンを設定
	SetIcon(wxICON(aramakiIcon));

	SetTitle(wxString(wxT("荒巻オンライン "))+VERSION);
}

void MainFrame::onClickSendButton(wxCommandEvent &) {
	send();
}

void MainFrame::onSelectLoginMenu(wxCommandEvent &) {
	LoginDialog loginDialog(this);

login:
	if (loginDialog.ShowModal()==wxID_OK) {
		//ログイン
		statusbar->SetLabel(wxT("ログインしています..."));

		//ログイン処理中は入力を受け付けない
		Enable(false);

		if (!World::login(loginDialog.getName(),loginDialog.getPort(),loginDialog.getNetwork())) {
			Enable(true);
			goto login;

			return;
		}

		//ログインメニューを無効にし、ログアウトメニューを有効にする
		loginMenuItem->Enable(false);
		logoutMenuItem->Enable(true);

		//入力を受け付ける
		Enable(true);

		statusbar->SetLabel(wxT("ログイン中"));
	}
}

void MainFrame::onSelectLogoutMenu(wxCommandEvent &) {
	statusbar->SetLabel(wxT("ログアウトしています..."));

	//ログアウト処理中は入力を受け付けない
	Enable(false);

	World::logout();

	loginMenuItem->Enable(true);
	logoutMenuItem->Enable(false);

	//入力を受け付ける
	Enable(true);

	statusbar->SetLabel(wxT("ログインしていません。"));
}

void MainFrame::onSelectChangeCharacterMenu(wxCommandEvent &) {

}

void MainFrame::onSelectIgnoreMenu(wxCommandEvent &) {

}

void MainFrame::onSelectEnableSeMenu(wxCommandEvent &) {
	Character::setEnableSe(enableSeMenuItem->IsChecked());
}

void MainFrame::onSelectTopmostMenu(wxCommandEvent &) {
	ToggleWindowStyle(wxSTAY_ON_TOP);
}

void MainFrame::onSelectManualMenu(wxCommandEvent &) {
	wxLaunchDefaultBrowser(wxT("http://backeros.if.land.to/index.php?%B9%D3%B4%AC%A5%AA%A5%F3%A5%E9%A5%A4%A5%F33%2F%A5%DE%A5%CB%A5%E5%A5%A2%A5%EB"));
}

void MainFrame::onSelectExitMenu(wxCommandEvent &) {
	Close();
}

void MainFrame::onKeyDownMessageEdit(wxKeyEvent &event) {
	switch(event.GetKeyCode()) {
	case WXK_RETURN:
		//Enterが押された
		if (wxGetKeyState(WXK_SHIFT)) {
			//Shift+Enter
			send();
		}
		break;
	case WXK_TAB:
		//Tabが押された
		//キャンバスにフォーカスをセット
		canvas->SetFocus();
		break;
	default:
		event.Skip();
	}
}

void MainFrame::send() {
	if (World::isLoggingIn()) MyCharacter::getInstance().setMessage(messageEdit->GetValue());
	messageEdit->Clear();
}

MainFrame &MainFrame::getInstance() {
	static MainFrame *instance=new MainFrame;
	return *instance;
}

void MainFrame::appendLog(const wxString &name,const wxString &message) {
	if (!logText->IsEmpty()) logText->AppendText(wxT("\n"));
	wxString logMessage=name+wxT("：")+message;
	//改行を削除
	logMessage.Replace(wxT("\n"),wxEmptyString,true);
	logText->AppendText(logMessage);
}
