/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CANVAS_H_
#define CANVAS_H_

#include <wx/wx.h>

#include <wx/glcanvas.h>
#ifdef __DARWIN__
    #include <OpenGL/glu.h>
#else
    #include <GL/glu.h>
#endif

class Canvas : public wxGLCanvas {
	//ウェイト
	static const int WAIT=33; /* 約30fps */

	wxStopWatch delayStopWatch;

	//移動可能フラグ
	bool movable;
	//初期化済みフラグ
	bool initialized;

	//描画
	void render();
	//再描画が必要な時
	void onPaint(wxPaintEvent &);
	//リサイズされた時
	void onSize(wxSizeEvent &event);
	//OpenGLを初期化
	void initGL();
	//キー入力をチェック
	void checkKeyInput(int frameCount) const;
	//視点を設定
	void resetProjectionMode();
	//キャンバスにフォーカスが設定された時
	void onSetFocus(wxFocusEvent &);
	//キャンバスからフォーカスが外れた時
	void onKillFocus(wxFocusEvent &);
	//キーが押された時
	void onKeyDown(wxKeyEvent &event);
	//アイドルイベント
	void onIdle(wxIdleEvent &event);
public:
	Canvas(wxWindow *parent);
	~Canvas();
};

#endif /*CANVAS_H_*/
