/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WORLD_H_
#define WORLD_H_

#include <list>
#include "P2PNetwork.h"
#include "Map.h"
#include "MyCharacter.h"
#include "Model.h"

class Map;
class MyCharacter;

class World {
	//マップ
	Map *map;
	//ネットワーク
	P2PNetwork *network;
	//自機
	MyCharacter *myCharacter;
	//空モデル
	static Model *sky;
	//初期化フラグ
	static bool initialized;
	//エラーフラグ
	bool error;
	//エラーメッセージ
	wxString errorMessage;

	//設定を読み込む
	void loadConfig(Point3d &initPosition,int &initDirection,wxString &portCheckerUrl);
	//初期化
	void initialize();
	//ポート開放チェック
	void portCheck(uint16_t listenPort);
public:
	World(uint16_t listenPort,const wxString &initNodeHost=wxEmptyString,uint16_t initNodePort=0);
	~World();
	//描画
	void draw() const;
	//マップ間移動
	void changeMap(const wxString &mapXmlFileName);

	inline bool isError() const {
		return error;
	}

	inline wxString getErrorMessage() const {
		return errorMessage;
	}

	inline MyCharacter &getMyCharacter() const {
		return *myCharacter;
	}
};

#endif /*WORLD_H_*/
