/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGETEXTCTRL_H_
#define MESSAGETEXTCTRL_H_

#include <wx/wx.h>

class MessageTextCtrl : public wxTextCtrl {
	void onKeyUp(wxKeyEvent &event);
	void onKeyDown(wxKeyEvent &event);

	DECLARE_EVENT_TABLE()
public:
	inline MessageTextCtrl(wxWindow *parent,wxWindowID id,const wxString &value=wxEmptyString,const wxPoint &pos=wxDefaultPosition,const wxSize &size=wxDefaultSize,long style=0,const wxValidator &validator=wxDefaultValidator,const wxString& name=wxTextCtrlNameStr) : wxTextCtrl(parent,id,value,pos,size,style,validator,name) {};
};

BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_EVENT_TYPE(wxEVT_TEXT_SHIFT_ENTER,1)
    DECLARE_EVENT_TYPE(wxEVT_TEXT_TAB,2)
END_DECLARE_EVENT_TYPES()

#define EVT_TEXT_SHIFT_ENTER(id, fn) \
    DECLARE_EVENT_TABLE_ENTRY( \
        wxEVT_TEXT_SHIFT_ENTER, id, wxID_ANY, \
        (wxObjectEventFunction)(wxEventFunction) wxStaticCastEvent( wxCommandEventFunction, &fn ), \
        (wxObject *) NULL \
    ),

#define EVT_TEXT_TAB(id, fn) \
    DECLARE_EVENT_TABLE_ENTRY( \
        wxEVT_TEXT_TAB, id, wxID_ANY, \
        (wxObjectEventFunction)(wxEventFunction) wxStaticCastEvent( wxCommandEventFunction, &fn ), \
        (wxObject *) NULL \
    ),

#endif /* MESSAGETEXTCTRL_H_ */
