/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "MessageTextCtrl.h"

BEGIN_EVENT_TABLE(MessageTextCtrl,wxTextCtrl)
	EVT_KEY_UP(MessageTextCtrl::onKeyUp)
	EVT_KEY_DOWN(MessageTextCtrl::onKeyDown)
END_EVENT_TABLE()

DEFINE_EVENT_TYPE(wxEVT_TEXT_SHIFT_ENTER)
DEFINE_EVENT_TYPE(wxEVT_TEXT_TAB)

void MessageTextCtrl::onKeyUp(wxKeyEvent &event) {
	if (event.GetKeyCode()==WXK_RETURN&&wxGetKeyState(WXK_SHIFT)) {
		wxCommandEvent newEvent(wxEVT_TEXT_SHIFT_ENTER,GetId());
		GetParent()->AddPendingEvent(newEvent);
	} else {
		event.Skip();
	}
}

void MessageTextCtrl::onKeyDown(wxKeyEvent &event) {
	if (event.GetKeyCode()==WXK_TAB) {
		wxCommandEvent newEvent(wxEVT_TEXT_TAB,GetId());
		GetParent()->AddPendingEvent(newEvent);
	} else if (!(event.GetKeyCode()==WXK_RETURN&&wxGetKeyState(WXK_SHIFT))) {
		event.Skip();
	}
}
