/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAP_H_
#define MAP_H_

#include <deque>
#include "Model.h"
#include "Point3d.h"
#include "Face.h"

class Model;

class Map {
	//フレーム
	struct Frame {
		//何フレーム表示するか
		int length;
		//残りフレーム数
		int count;
		//表示用モデル
		Model *model;
	};

	//フレームキュー
	typedef std::deque<Frame> FrameQueue;

	FrameQueue frameQueue;

	//当たり判定用モデル
	Model *hitTestModel;
	//マップXMLファイル名
	wxString mapXmlFileName;

	Map(const Map &);
	void operator=(const Map &);
public:
	Map(const wxString &mapXmlFileName);

	inline ~Map() {
		for (FrameQueue::iterator i=frameQueue.begin();i!=frameQueue.end();++i) delete i->model;
		delete hitTestModel;
	}

	void draw();

	//線分と当たり判定を取る
	inline bool collide(const Point3d &lineStart,const Point3d &lineEnd,Point3d &crossPoint,Face &hitFace) const {
		return hitTestModel->collide(lineStart,lineEnd,crossPoint,hitFace);
	}

	inline const wxString &getMapXmlFileName() const {
		return mapXmlFileName;
	}
};

#endif /*MAP_H_*/
