/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LOGINDIALOG_H_
#define LOGINDIALOG_H_

#include <wx/wx.h>

class LoginDialog : public wxDialog {
	//サイザー
	wxBoxSizer *sizer,*nameSizer,*buttonSizer;
	wxStaticBoxSizer *initNodeSizer,*listenSizer;
	//名前入力欄
	wxTextCtrl *nameEdit;
	//初期ノードのホスト入力欄
	wxTextCtrl *initNodeHostEdit;
	//初期ノードのポート入力欄
	wxTextCtrl *initNodePortEdit;
	//接続受付ポート入力欄
	wxTextCtrl *listenPortEdit;
	//ネットワークに接続ボタン
	wxButton *connectToNetworkButton;
	//ネットワークを作成ボタン
	wxButton *createNetworkButton;
	//終了ボタン
	wxButton *exitButton;

	//ボタンが押された
	void onClickButton(wxCommandEvent &event);

	DECLARE_EVENT_TABLE();
public:
	//ID
	static const int ID_BUTTON_CONNECT_TO_NETWORK=1;
	static const int ID_BUTTON_CREATE_NETWORK=2;

	LoginDialog(wxFrame *parent);

	inline wxString getName() const {
		return nameEdit->GetValue();
	}

	inline wxString getInitNodeHost() const {
		return initNodeHostEdit->GetValue();
	}

	inline uint16_t getInitNodePort() const {
		long port=0;

		initNodePortEdit->GetValue().ToLong(&port);

		return port;
	}

	inline uint16_t getListenPort() const {
		long port=0;

		listenPortEdit->GetValue().ToLong(&port);

		return port;
	}
};

#endif /* LOGINDIALOG_H_ */
