/*
 *  Aramaki Online
 *  Copyright (C) 2005 - 2011  superbacker
 *  
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>
 */
package net.scaltinof.aramaki.client.engine3d.objects.avatar;

import net.scaltinof.aramaki.client.engine3d.geom.Vector2D;

import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;

public class Sprite {
	private Image image;
	private Vector2D origin;
	private Vector2D size;
	private boolean loaded = false;
	//FIXME
	private SpriteLoadHandler handler;
	
	public Sprite(String url, Vector2D size, Vector2D origin) {
		this.image = new Image(url);
		this.size = size;
		this.origin = origin;
		
		image.setVisible(false);
		RootPanel.get().add(image);
		
		image.addLoadHandler(new LoadHandler() {
			@Override
			public void onLoad(LoadEvent event) {
				loaded = true;
				RootPanel.get().remove(image);
				if (handler != null) {
					handler.onLoad(Sprite.this);
				}
			}
		});
	}
	
	public boolean isLoaded() {
		return loaded;
	}
	
	public ImageElement asImageElement() {
		return image.getElement().<ImageElement>cast();
	}
	
	public double height() {
		return size.y;
	}
	
	public float[] getRect() throws IllegalStateException {
		if (!loaded) {
			throw new IllegalStateException("スプライトがロードされていません");
		}
		
		final float x1 = -(float)size.x * (float)origin.x;
		final float y1 = -(float)size.y * (float)origin.y;
		final float x2 = (float)size.x + x1;
		final float y2 = (float)size.y + y1;
		return new float[] {
			x1, y2,
			x1, y1,
			x2, y2,
			x2, y1
		};
	}
	
	public void waitLoad(SpriteLoadHandler handler) {
		//FIXME
		this.handler = handler;
	}
	
	public Vector2D getOrigin() {
		return new Vector2D(origin.x * size.x, origin.y * size.y);
	}
}
