/*
 *  Aramaki Online
 *  Copyright (C) 2005 - 2011  superbacker
 *  
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>
 */
package net.scaltinof.aramaki.client.engine3d.objects.avatar;

import net.scaltinof.aramaki.client.utils.AutoLink;

import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class AvatarOverlay extends Composite {
	private static final Binder binder = GWT.create(Binder.class);
	
	interface Binder extends UiBinder<Widget, AvatarOverlay> {
	}
	
	@UiField Label nameLabel;
	@UiField HTML balloon;
	@UiField Image balloonTail;
	@UiField VerticalPanel panel;
	@UiField VerticalPanel balloonContainer;
	
	private Logger logger;
	
	public AvatarOverlay(Logger logger) {
		this.logger = logger;
		initWidget(binder.createAndBindUi(this));
	}
	
	/**
	 * 名前を設定する
	 * @param name 名前
	 */
	public void setName(String name) {
		nameLabel.setText(name);
	}
	
	/**
	 * ふきだしに表示するテキストを設定する
	 * @param text ふきだしの中身
	 */
	public void setBalloon(String text) {
		if (text.isEmpty()) {
			balloonContainer.setVisible(false);
			balloonTail.setVisible(false);
			return;
		}
		
		if (text.equals(balloon.getText())) {
			return;
		}
		SafeHtmlBuilder builder = new SafeHtmlBuilder();
		builder.appendHtmlConstant(AutoLink.escapeLinesURLToLink(text));
		balloon.setHTML(builder.toSafeHtml());
		
		balloonContainer.setVisible(true);
		balloonTail.setVisible(true);
		
		logger.append(nameLabel.getText(), text);
	}
}
