unit uTabSheet;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var
  cTabSheet: Tvalue;

function ap_cTabSheet: Tvalue;
function ap_iTabSheet(real: TTabSheet; owner: Tvalue): Tvalue;
procedure Init_TabSheet;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cTabSheet: Tvalue;
begin
  result := cTabSheet;
end;

procedure TabSheet_setup(obj: Tvalue; real: TTabSheet);
begin
  ap_set_child_attr_module(obj);
//    AssignPropMethod(real, [Handle]);
end;

function TabSheet_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function TabSheet_alloc(This: Tvalue; real: TTabSheet): Tvalue;
begin
  result := ChildAlloc(This, real);
  TabSheet_setup(result, real);
end;

function ap_iTabSheet(real: TTabSheet; owner: Tvalue): Tvalue;
begin
  result := TabSheet_alloc(cTabSheet, real);
  ap_owner(result, owner);
end;

function ap_iTabSheet_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iTabSheet(TTabSheet(AControl), owner);
end;

function TabSheet_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TTabSheet;
  PageControl: TPageControl;
begin
  real := TTabSheet.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ap_data_get_object(Pvalue(argv)^, TPageControl, PageControl);
  real.PageControl := PageControl;
  TabSheet_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function TabSheet_get_page_control(This: Tvalue): Tvalue; cdecl;
var
  real: TTabSheet;
  PageControl: TPageControl;
begin
  real := ap_data_get_struct(This);
  PageControl := real.PageControl;
  if PageControl = nil then
    result := Qnil
  else
    result := PageControl.tag
  ;
end;

function TabSheet_set_page_control(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTabSheet;
  PageControl: TPageControl;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPageControl, PageControl);
  real.PageControl := PageControl;
  result := v;
end;

procedure Init_TabSheet;
begin
  cTabSheet := OutputPersistentClass(mPhi, TTabSheet, cWinControl, ap_iTabSheet_v);
  rb_define_method(cTabSheet, 'event_handle', @TabSheet_event_handle, 1);
  DefineSingletonMethod(cTabSheet, 'new', TabSheet_new);
  DefineAttrGet(cTabSheet, 'page_control', TabSheet_get_page_control);
  DefineAttrSet(cTabSheet, 'page_control', TabSheet_set_page_control);
end;

end.
