unit uStatusBar;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var
  cStatusBar: Tvalue;

function ap_cStatusBar: Tvalue;
function ap_iStatusBar(real: TStatusBar; owner: Tvalue): Tvalue;
procedure Init_StatusBar;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uFont, uCanvas,
  uPersistent, uComponent, uControl;

function ap_cStatusBar: Tvalue;
begin
  result := cStatusBar;
end;

procedure StatusBar_setup(obj: Tvalue; real: TStatusBar);
begin
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
//    AssignPropMethod(real, [Handle]);
end;

function StatusBar_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function StatusBar_alloc(This: Tvalue; real: TStatusBar): Tvalue;
begin
  result := ChildAlloc(This, real);
  StatusBar_setup(result, real);
end;

function ap_iStatusBar(real: TStatusBar; owner: Tvalue): Tvalue;
begin
  result := StatusBar_alloc(cStatusBar, real);
  ap_owner(result, owner);
end;

function ap_iStatusBar_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iStatusBar(TStatusBar(AControl), owner);
end;

function StatusBar_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStatusBar;
begin
  real := TStatusBar.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  StatusBar_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_StatusBar;
begin
  cStatusBar := OutputPersistentClass(mPhi, TStatusBar, cControl, ap_iStatusBar_v);
  rb_define_method(cStatusBar, 'event_handle', @StatusBar_event_handle, 1);
  DefineSingletonMethod(cStatusBar, 'new', StatusBar_new);
end;

end.
