unit uSpeedButton;

interface

uses
{$IFDEF VCL}
  Buttons,
{$ELSE}
  QButtons,
{$ENDIF}
  Rubies;

var
  cSpeedButton: Tvalue;

function ap_cSpeedButton: Tvalue;
function ap_iSpeedButton(real: TSpeedButton; owner: Tvalue): Tvalue;
procedure Init_SpeedButton;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cSpeedButton: Tvalue;
begin
  result := cSpeedButton;
end;

procedure SpeedButton_setup(obj: Tvalue; real: TSpeedButton);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
//    AssignPropMethod(real, [Handle]);
end;

function SpeedButton_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function SpeedButton_alloc(klass: Tvalue; real: TSpeedButton): Tvalue;
begin
  result := ChildAlloc(klass, real);
  SpeedButton_setup(result, real);
end;

function ap_iSpeedButton(real: TSpeedButton; owner: Tvalue): Tvalue;
begin
  result := SpeedButton_alloc(cSpeedButton, real);
  ap_owner(result, owner);
end;

function ap_iSpeedButton_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iSpeedButton(TSpeedButton(AControl), owner);
end;

function SpeedButton_new(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSpeedButton;
begin
  real := TSpeedButton.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  SpeedButton_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_SpeedButton;
begin
  cSpeedButton := OutputPersistentClass(mPhi, TSpeedButton, cControl, ap_iSpeedButton_v);
  rb_define_method(cSpeedButton, 'event_handle', @SpeedButton_event_handle, 1);
  DefineSingletonMethod(cSpeedButton, 'new', SpeedButton_new);
end;

end.
