unit uRichEdit;

interface

uses Rubies, ComCtrls;

var
  cRichEdit: Tvalue;

function ap_cRichEdit: Tvalue;
function ap_iRichEdit(real: TRichEdit; owner: Tvalue): Tvalue;
procedure Init_RichEdit;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uStrings, uFont, uEdit,
  uPersistent, uComponent, uControl;

function ap_cRichEdit: Tvalue;
begin
  result := cRichEdit;
end;

procedure RichEdit_setup(obj: Tvalue; real: TRichEdit);
begin
  rb_iv_set(obj, '@lines', ap_iStrings(real.Lines, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle]);
end;

function RichEdit_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function RichEdit_alloc(This: Tvalue; real: TRichEdit): Tvalue;
begin
  result := ChildAlloc(This, real);
  RichEdit_setup(result, real);
end;

function ap_iRichEdit(real: TRichEdit; owner: Tvalue): Tvalue;
begin
  result := RichEdit_alloc(cRichEdit, real);
  ap_owner(result, owner);
end;

function ap_iRichEdit_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iRichEdit(TRichEdit(AControl), owner);
end;

function RichEdit_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := TRichEdit.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  RichEdit_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function RichEdit_clear(This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  real.Clear;
  result := This;
end;

function RichEdit_set_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  real.Text := dl_String(v);
  result := v;
end;

function RichEdit_get_text(This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(real.Text));
end;

procedure Init_RichEdit;
begin
  cRichEdit := OutputPersistentClass(mPhi, TRichEdit, cEdit, ap_iRichEdit_v);
  rb_define_method(cRichEdit, 'event_handle', @RichEdit_event_handle, 1);
  DefineSingletonMethod(cRichEdit, 'new', RichEdit_new);
  rb_define_method(cRichEdit, 'clear', @RichEdit_clear, 0);
  DefineAttrGet(cRichEdit, 'text', RichEdit_get_text);
  DefineAttrSet(cRichEdit, 'text', RichEdit_set_text);
end;

end.
