unit uProgressBar;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var
  cProgressBar: Tvalue;

function ap_cProgressBar: Tvalue;
function ap_iProgressBar(real: TProgressBar; owner: Tvalue): Tvalue;
procedure Init_ProgressBar;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cProgressBar: Tvalue;
begin
  result := cProgressBar;
end;

procedure ProgressBar_setup(obj: Tvalue; real: TProgressBar);
begin
//    AssignPropMethod(real, [Handle]);
end;

function ProgressBar_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ProgressBar_alloc(This: Tvalue; real: TProgressBar): Tvalue;
begin
  result := ChildAlloc(This, real);
  ProgressBar_setup(result, real);
end;

function ap_iProgressBar(real: TProgressBar; owner: Tvalue): Tvalue;
begin
  result := ProgressBar_alloc(cProgressBar, real);
  ap_owner(result, owner);
end;

function ap_iProgressBar_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iProgressBar(TProgressBar(AControl), owner);
end;

function ProgressBar_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TProgressBar;
begin
  real := TProgressBar.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ProgressBar_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_ProgressBar;
begin
  cProgressBar := OutputPersistentClass(mPhi, TProgressBar, cWinControl, ap_iProgressBar_v);
  rb_define_method(cProgressBar, 'event_handle', @ProgressBar_event_handle, 1);
  DefineSingletonMethod(cProgressBar, 'new', ProgressBar_new);
end;

end.
