unit uMaskEdit;

interface

uses
{$IFDEF VCL}
  Mask,
{$ELSE}
  QMask,
{$ENDIF}
  Rubies;

var
  cMaskEdit: Tvalue;

function ap_cMaskEdit: Tvalue;
function ap_iMaskEdit(real: TMaskEdit; owner: Tvalue): Tvalue;
procedure Init_MaskEdit;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uFont,
  uPersistent, uComponent, uControl;

function ap_cMaskEdit: Tvalue;
begin
  result := cMaskEdit;
end;

procedure MaskEdit_setup(obj: Tvalue; real: TMaskEdit);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle]);
end;

function MaskEdit_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function MaskEdit_alloc(klass: Tvalue; real: TMaskEdit): Tvalue;
begin
  result := ChildAlloc(klass, real);
  MaskEdit_setup(result, real);
end;

function ap_iMaskEdit(real: TMaskEdit; owner: Tvalue): Tvalue;
begin
  result := MaskEdit_alloc(cMaskEdit, real);
  ap_owner(result, owner);
end;

function ap_iMaskEdit_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iMaskEdit(TMaskEdit(AControl), owner);
end;

function MaskEdit_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TMaskEdit;
begin
  real := TMaskEdit.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  MaskEdit_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_MaskEdit;
begin
  cMaskEdit := OutputPersistentClass(mPhi, TMaskEdit, cWinControl, ap_iMaskEdit_v);
  rb_define_method(cMaskEdit, 'event_handle', @MaskEdit_event_handle, 1);
  DefineSingletonMethod(cMaskEdit, 'new', MaskEdit_new);
end;

end.
