unit uListView;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var
  cIconOptions, cListView: Tvalue;

function ap_cIconOptions: Tvalue;
function ap_cListView: Tvalue;
function ap_iListView(real: TListView; owner: Tvalue): Tvalue;
procedure Init_ListView;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uIO, uConv,
  uSizeConstraints, uCanvas, uFont, uListItem, uListColumn,
  uPersistent, uComponent, uControl;

function ap_cIconOptions: Tvalue;
begin
  result := cIconOptions;
end;

function ap_cListView: Tvalue;
begin
  result := cListView;
end;

function IconOptions_alloc(This: Tvalue; real: TIconOptions): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function ap_iIconOptions(real: TIconOptions; owner: Tvalue): Tvalue;
begin
  result := IconOptions_alloc(cIconOptions, real);
  ap_owner(result, owner);
end;

procedure ListView_setup(obj: Tvalue; real: TListView);
begin
{$IFDEF VCL}
  rb_iv_set(obj, '@icon_options', ap_iIconOptions(real.IconOptions, obj));
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
{$ENDIF}
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  rb_iv_set(obj, '@items', ap_iListItems(real.Items, obj));
  rb_iv_set(obj, '@columns', ap_iListColumns(real.Columns, obj));
//    AssignPropMethod(real, [Handle]);
end;

function ListView_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ListView_alloc(This: Tvalue; real: TListView): Tvalue;
begin
  result := ChildAlloc(This, real);
  ListView_setup(result, real);
end;

function ap_iListView(real: TListView; owner: Tvalue): Tvalue;
begin
  result := ListView_alloc(cListView, real);
  ap_owner(result, owner);
end;

function ap_iListView_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iListView(TListView(AControl), owner);
end;

function ListView_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TListView;
begin
  real := TListView.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ListView_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function ListView_get_selected(This: Tvalue): Tvalue; cdecl;
var
  real: TListView;
  item: TListItem;
begin
  real := ap_data_get_struct(This);
  item := real.Selected;
  if item = nil then
    result := Qnil
  else
    result := Tvalue(item.Data);
end;

function ListView_item_at(This, x, y: Tvalue): Tvalue; cdecl;
var
  real: TListView;
  item: TListItem;
begin
  real := ap_data_get_struct(This);
  item := real.GetItemAt(dl_Integer(x), dl_Integer(y));
  if item = nil then
    result := Qnil
  else
    result := Tvalue(item.Data);
end;

{$IFDEF VCL}
function ListView_hit_test_info_at(This, x, y: Tvalue): Tvalue; cdecl;
var
  real: TListView;
  tests: THitTests;
begin
  real := ap_data_get_struct(This);
  tests := real.GetHitTestInfoAt(dl_Integer(x), dl_Integer(y));
  result := ap_set_to_ary(tests);
end;
{$ENDIF}

procedure Init_ListView;
begin
  OutputConstSetType(mPhi, TypeInfo(TIconArrangement));
  OutputConstSetType(mPhi, TypeInfo(TItemChange));

  cIconOptions := rb_define_class_under(mPhi, 'IconOptions', ap_cObject);
  OutputProp(cIconOptions, TIconOptions);

  OutputConstSetType(mPhi, TypeInfo(TViewStyle));

  cListView := OutputPersistentClass(mPhi, TListView, cWinControl, ap_iListView_v);
  DefineAttrGet(cListView, 'selected', ListView_get_selected);
  rb_define_attr(cListView, 'items', 1, 0);

  rb_define_method(cListView, 'event_handle', @ListView_event_handle, 1);
  DefineSingletonMethod(cListView, 'new', ListView_new);
  rb_define_attr(cListView, 'canvas', 1, 0);

  rb_define_method(cListView, 'item_at', @ListView_item_at, 2);
{$IFDEF VCL}
  rb_define_method(cListView, 'hit_test_info_at', @ListView_hit_test_info_at, 2);
{$ENDIF}
end;

end.
