unit uListColumn;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var
  cListColumn, cListColumns: Tvalue;

function ap_cListColumn: Tvalue;
function ap_iListColumn(real: TListColumn; owner: Tvalue): Tvalue;
function ap_cListColumns: Tvalue;
function ap_iListColumns(real: TListColumns; owner: Tvalue): Tvalue;
procedure Init_ListColumn;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uCollection,
  uPersistent, uComponent, uControl;

function ap_cListColumn: Tvalue;
begin
  result := cListColumn;
end;

function ap_cListColumns: Tvalue;
begin
  result := cListColumns;
end;

procedure ListColumn_setup(obj: Tvalue; real: TListColumn);
begin
//
end;

function ListColumn_alloc(This: Tvalue; real: TListColumn): Tvalue;
begin
  result := TmpAlloc(This, real);
  ListColumn_setup(result, real);
end;

function ap_iListColumn(real: TListColumn; owner: Tvalue): Tvalue;
begin
  result := ListColumn_alloc(cListColumn, real);
  ap_owner(result, owner);
end;

function ap_iListColumn_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iListColumn(TListColumn(AControl), owner);
end;

function ListColumn_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TListColumn;
  source: TPersistent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPersistent, source);
  real.Assign(source);
  result := v;
end;

procedure ListColumns_setup(obj: Tvalue; real: TListColumns);
begin
  Collection_setup(obj, real);
end;

function ListColumns_alloc(This: Tvalue; real: TListColumns): Tvalue;
begin
  result := TmpAlloc(This, real);
  ListColumns_setup(result, real);
end;

function ap_iListColumns(real: TListColumns; owner: Tvalue): Tvalue;
begin
  result := ListColumns_alloc(cListColumns, real);
  ap_owner(result, owner);
end;

function ap_iListColumns_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iListColumns(TListColumns(AControl), owner);
end;

procedure Init_ListColumn;
begin
  cListColumn := OutputPersistentClass(ap_mPhi, TListColumn, ap_cCollectionItem, ap_iListColumn_v);
  rb_define_method(cListColumn, 'assign', @ListColumn_assign, 1);

  cListColumns := OutputPersistentClass(ap_mPhi, TListColumns, ap_cCollection, ap_iListColumns_v);
  SetCollectionItemClass(cListColumns, 'TListColumn');
end;

end.
