unit uEdit;

interface

uses
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  Rubies;

var
  cEdit: Tvalue;

function ap_cEdit: Tvalue;
function ap_iEdit(real: TEdit; owner: Tvalue): Tvalue;
procedure Init_edit;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uConv,
  uSizeConstraints, uFont,
  uPersistent, uComponent, uControl;

function ap_cEdit: Tvalue;
begin
  result := cEdit;
end;

procedure Edit_setup(obj: Tvalue; real: TEdit);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle]);
end;

function Edit_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Edit_alloc(klass: Tvalue; real: TEdit): Tvalue;
begin
  result := ChildAlloc(klass, real);
  Edit_setup(result, real);
end;

function ap_iEdit(real: TEdit; owner: Tvalue): Tvalue;
begin
  result := Edit_alloc(cEdit, real);
  ap_owner(result, owner);
end;

function ap_iEdit_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iEdit(TEdit(AControl), owner);
end;

function Edit_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := TEdit.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Edit_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function Edit_set_sel_start(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  real.SelStart := dl_Integer(v);
  result := v;
end;

function Edit_get_sel_start(This: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.SelStart);
end;

function Edit_set_sel_length(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  real.SelLength := dl_Integer(v);
  result := v;
end;

function Edit_get_sel_length(This: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.SelLength);
end;

function Edit_set_sel_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  real.SelText := dl_String(v);
  result := v;
end;

function Edit_get_sel_text(This: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.SelText);
end;

procedure Init_edit;
begin
  OutputConstSetType(mPhi, TypeInfo(TEditCharCase));
  cEdit := OutputPersistentClass(mPhi, TEdit, cWinControl, ap_iEdit_v);
  rb_define_method(cEdit, 'event_handle', @Edit_event_handle, 1);
  DefineSingletonMethod(cEdit, 'new', Edit_new);
  DefineAttrGet(cEdit, 'sel_start', Edit_get_sel_start);
  DefineAttrSet(cEdit, 'sel_start', Edit_set_sel_start);
  DefineAttrGet(cEdit, 'sel_length', Edit_get_sel_length);
  DefineAttrSet(cEdit, 'sel_length', Edit_set_sel_length);
  DefineAttrGet(cEdit, 'sel_text', Edit_get_sel_text);
  DefineAttrSet(cEdit, 'sel_text', Edit_set_sel_text);
end;

end.
