unit uDataModule;

interface

uses Classes, Rubies;

var
  cDataModule: Tvalue;

function ap_cDataModule: Tvalue;
function ap_iDataModule(real: TDataModule; owner: Tvalue): Tvalue;
procedure Init_DataModule;

implementation

uses
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uPersistent;

function ap_cDataModule: Tvalue;
begin
  result := cDataModule;
end;

procedure DataModule_setup(obj: Tvalue; real: TDataModule);
begin
  ap_set_child_attr_module(obj);
end;

function DataModule_alloc(This: Tvalue; real: TDataModule): Tvalue;
begin
  result := ChildAlloc(This, real);
  DataModule_setup(result, real);
end;

function ap_iDataModule(real: TDataModule; owner: Tvalue): Tvalue;
begin
  result := DataModule_alloc(cDataModule, real);
  ap_owner(result, owner);
end;

function ap_iDataModule_v(var AControl; owner: Tvalue): Tvalue;
var
  real: TDataModule;
begin
  real := TDataModule(AControl);
  result := ap_iDataModule(real, owner);
end;

procedure Init_DataModule;
begin
  cDataModule := OutputPersistentClass(mPhi, TDataModule, cPersistent, ap_iDataModule_v);
end;

end.
