unit uCreateParams;

interface

uses Rubies, Controls;

{
  TCreateParams = record
    Caption: PChar;
    Style: DWORD;
    ExStyle: DWORD;
    X, Y: Integer;
    Width, Height: Integer;
    WndParent: HWND;
    Param: Pointer
    WindowClass: TWndClass;
    WinClassName: array[0..63] of Char;
  end;
}
var
  sCreateParams: Tvalue;

function CreateParams_alloc(real: TCreateParams): Tvalue;
procedure CreateParams_assign(var real: TCreateParams; v: Tvalue);
procedure Init_CreateParams;

implementation

uses uStrUtils, uDefUtils, uPhi, uConv;

function CreateParams_alloc(real: TCreateParams): Tvalue;
var
  ary: Tvalue;
begin
  ary := rb_ary_new;
  rb_ary_push(ary, ap_String(real.Caption));
  rb_ary_push(ary, ap_Fixnum(real.Style));
  rb_ary_push(ary, ap_Fixnum(real.ExStyle));
  rb_ary_push(ary, ap_Fixnum(real.X));
  rb_ary_push(ary, ap_Fixnum(real.Y));
  rb_ary_push(ary, ap_Fixnum(real.Width));
  rb_ary_push(ary, ap_Fixnum(real.Height));
  result := rb_struct_alloc(sCreateParams, ary);
end;

procedure CreateParams_assign(var real: TCreateParams; v: Tvalue);
var
  ary: Tvalue;
begin
  ary := rb_funcall2(v, rb_intern('to_a'), 0, nil);
  real.Caption := PChar(dl_String(rb_ary_shift(ary)));
  real.Style := dl_Integer(rb_ary_shift(ary));
  real.ExStyle := dl_Integer(rb_ary_shift(ary));
  real.X := dl_Integer(rb_ary_shift(ary));
  real.Y := dl_Integer(rb_ary_shift(ary));
  real.Width := dl_Integer(rb_ary_shift(ary));
  real.Height := dl_Integer(rb_ary_shift(ary));
end;

const
  props: array[0..6] of PChar = (
    'Caption',
    'Style',
    'ExStyle',
    'X',
    'Y',
    'Width',
    'Height'
  );

procedure Init_CreateParams;
var
  ary: Tvalue;
  i: Integer;
begin
  ary := rb_ary_new;
  rb_ary_push(ary, rb_str_new2('CreateParams'));
  for i := low(props) to high(props) do
    rb_ary_push(ary, ap_String(LowerCase1(props[i])));
  sCreateParams := rb_apply(ap_cStruct, rb_intern('new'), ary);
  rb_global_variable(@sCreateParams);
end;

end.
