unit uComponent;

interface

uses Rubies, SysUtils, Classes;

var
  cComponent: Tvalue;

function ap_cComponent: Tvalue;
procedure SetParentAttr(obj, ceo: Tvalue; name: PChar);
procedure RemoveParentAttr(real: TComponent);
procedure CompoSetup(argc: integer; argv: Pointer; real: TComponent);
procedure Init_Component;

implementation

uses
{$IFDEF VCL}
  Controls,
{$ELSE}
  QControls,
{$ENDIF}
  uDefUtils, uHandle, uError, uPhi, uProp, uPropInfo, uTypeInfo, uMarshal, uPersistent;

function ap_cComponent: Tvalue;
begin
  result := cComponent;
end;

procedure SetParentAttr(obj, ceo: Tvalue; name: PChar);
var
  module: Tvalue;
begin
  rb_iv_set(ceo, PChar('@'+name), obj);
  module := rb_iv_get(ceo, '@child_attr_module');
  if module = Qnil then
    ap_raise(eDelphiError, 'child attr module not defined');
  rb_define_attr(module, name, 1, 0);
end;

procedure RemoveParentAttr(real: TComponent);
var
  obj, ceo, module: Tvalue;
begin
  if Length(real.name) = 0 then Exit;
  obj := real.tag;
  ceo := rb_iv_get(obj, '@parent');
  rb_iv_set(ceo, PChar('@'+real.name), Qnil);

  module := rb_iv_get(ceo, '@child_attr_module');
  if module = Qnil then Exit;
  rb_undef_method(module, PChar(real.name));
end;

procedure CompoSetup(argc: integer; argv: Pointer; real: TComponent);
var
  args: array of Tvalue;
  parent: TComponent;
  obj, ceo: Tvalue;
  str: PChar;

  procedure value_set_if_defined(obj: Tvalue; S: PChar; v:Tvalue);
  begin
    if Boolean(rb_method_boundp(CLASS_OF(obj), rb_intern(S), 1)) then
      rb_funcall2(obj, rb_intern(S), 1, @v);
  end;

begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  ap_data_get_object(args[0], TComponent, parent);

  obj := real.tag;
  if parent = nil then
    ceo := Qnil
  else
    ceo := parent.tag;

  if argc > 1 then
    str := dl_caption(args[1])
  else
    str := PChar('c_' + IntToStr(real.tag));

  SetParentAttr(obj, ceo, str);
  try
    real.name := str;
  except
    on E: Exception do
        ap_raise(ap_eArgError, E.message);
  end;

  if argc = 1 then
  begin
    value_set_if_defined(obj, 'text=', rb_str_new(PChar(''), 1));
    value_set_if_defined(obj, 'caption=', rb_str_new(PChar(''), 1));
  end
  else
  if argc > 2 then
  begin
    value_set_if_defined(obj, 'text=', args[2]);
    value_set_if_defined(obj, 'caption=', args[2]);
  end;

  if (real is TControl) and (parent is TWinControl) then
    TControl(real).parent := TWinControl(parent);
  rb_iv_set(obj, '@parent', ceo);
end;

function Component_type_info(This: Tvalue): Tvalue; cdecl;
begin
  result := TypeInfo_new(cTypeInfo, This);
end;

function Component_prop_info(This, prop: Tvalue): Tvalue; cdecl;
begin
  result := PropInfo_new(cPropInfo, This, prop);
end;

function Component_dump(This, limit_obj: Tvalue): Tvalue; cdecl;
var
  real: TComponent;
  limit: Integer;
begin
  real := ap_data_get_struct(This);
  limit := FIX2INT(limit_obj);
  result := rb_str_new2(PChar(ComponentToString1(real, limit, 0)));
end;

function Component_write_res_file(This, name: Tvalue): Tvalue; cdecl;
var
  real: TComponent;
begin
  real := ap_data_get_struct(This);
  WriteComponentResFile(dl_String(name), real);
  result := This;
end;

function Component_get_component_count(This: Tvalue): Tvalue; cdecl;
var
  real: TComponent;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ComponentCount);
end;

function Component_get_components(This: Tvalue): Tvalue; cdecl;
var
  real: TComponent;
  i: Integer;
begin
  real := ap_data_get_struct(This);
  result := rb_ary_new;
  for i := 0 to real.ComponentCount-1 do
    rb_ary_push(result, real.Components[i].tag);
end;

procedure Init_Component;
begin
  cComponent := rb_define_class_under(mPhi, 'Component', ap_cPersistent);
  rb_define_singleton_method(cComponent, 'type_info', @Component_type_info, 0);
  rb_define_method(cComponent, 'prop_info', @Component_prop_info, 1);
  rb_define_method(cComponent, '_dump', @Component_dump, 1);
  rb_define_method(cComponent, 'write_res_file', @Component_write_res_file, 1);
  DefineAttrGet(cComponent, 'component_count', Component_get_component_count);
  DefineAttrGet(cComponent, 'components', Component_get_components);
end;

end.
