unit uComboBox;

interface

uses
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  Rubies;

var
  cComboBox: Tvalue;

function ap_cComboBox: Tvalue;
procedure ComboBox_setup(obj: Tvalue; real: TComboBox);
function ComboBox_alloc(klass: Tvalue; real: TComboBox): Tvalue;
function ap_iComboBox(real: TComboBox; owner: Tvalue): Tvalue;
procedure Init_ComboBox;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uConv,
  uSizeConstraints, uCanvas, uFont, uStrings,
  uPersistent, uComponent, uControl;

function ap_cComboBox: Tvalue;
begin
  result := cComboBox;
end;

procedure ComboBox_setup(obj: Tvalue; real: TComboBox);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  rb_iv_set(obj, '@items', ap_iStrings(real.Items, obj));
//    AssignPropMethod(real, [Handle]);
end;

function ComboBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ComboBox_alloc(klass: Tvalue; real: TComboBox): Tvalue;
begin
  result := ChildAlloc(klass, real);
  ComboBox_setup(result, real);
end;

function ap_iComboBox(real: TComboBox; owner: Tvalue): Tvalue;
begin
  result := ComboBox_alloc(cComboBox, real);
  ap_owner(result, owner);
end;

function ap_iComboBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iComboBox(TComboBox(AControl), owner);
end;

function ComboBox_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := TComboBox.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ComboBox_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function ComboBox_set_char_case(This, v: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  real.CharCase := TEditCharCase(FIX2INT(v));
  result := v;
end;

function ComboBox_get_char_case(This: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(Ord(real.CharCase));
end;

function ComboBox_set_item_index(This, v: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  real.ItemIndex := dl_Integer(v);
  result := v;
end;

function ComboBox_get_item_index(This: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.ItemIndex);
end;

function ComboBox_set_sel_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  real.SelText := dl_String(v);
  result := v;
end;

function ComboBox_get_sel_text(This: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.SelText);
end;

procedure Init_ComboBox;
begin
  OutputConstSetType(mPhi, TypeInfo(TComboBoxStyle));

  cComboBox := OutputPersistentClass(mPhi, TComboBox, cWinControl, ap_iComboBox_v);
  rb_define_method(cComboBox, 'event_handle', @ComboBox_event_handle, 1);
  DefineSingletonMethod(cComboBox, 'new', ComboBox_new);
  DefineAttrSet(cComboBox, 'char_case', ComboBox_set_char_case);
  DefineAttrGet(cComboBox, 'char_case', ComboBox_get_char_case);
  DefineAttrSet(cComboBox, 'item_index', ComboBox_set_item_index);
  DefineAttrGet(cComboBox, 'item_index', ComboBox_get_item_index);
  DefineAttrSet(cComboBox, 'sel_text', ComboBox_set_sel_text);
  DefineAttrGet(cComboBox, 'sel_text', ComboBox_get_sel_text);
end;

end.
