unit uButton;

interface

uses
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  Rubies;

var
  cButton: Tvalue;

function ap_cButton: Tvalue;
procedure Button_setup(obj: Tvalue; real: TButton);
function ap_iButton(real: TButton; owner: Tvalue): Tvalue;
procedure Init_Button;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cButton: Tvalue;
begin
  result := cButton;
end;

procedure Button_setup(obj: Tvalue; real: TButton);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
//  AssignPropMethod(real, [Handle]);
end;

function Button_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Button_alloc(This: Tvalue; real: TButton): Tvalue;
begin
  result := ChildAlloc(This, real);
  Button_setup(result, real);
end;

function ap_iButton(real: TButton; owner: Tvalue): Tvalue;
begin
  result := Button_alloc(cButton, real);
  ap_owner(result, owner);
end;

function ap_iButton_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iButton(TButton(AControl), owner);
end;

function Button_new(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TButton;
begin
  real := TButton.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Button_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function Button_click(This: Tvalue):Tvalue; cdecl;
var
  real:TButton;
begin
  real := ap_data_get_struct(This);
  real.Click;
  result := This;
end;

procedure Init_Button;
begin
  cButton := OutputPersistentClass(mPhi, TButton, cWinControl, ap_iButton_v);
  rb_define_method(cButton, 'event_handle', @Button_event_handle, 1);
  DefineSingletonMethod(cButton, 'new', Button_new);
  rb_define_method(cButton, 'click', @Button_click, 0);
end;

end.
