unit uBrush;

interface

uses
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  Rubies;

var
  cBrush: Tvalue;

function ap_cBrush: Tvalue;
function ap_iBrush(real: TBrush; owner: Tvalue): Tvalue;
procedure Init_Brush;

implementation

uses
  Classes,
  uDefUtils, uIntern, uAlloc, uProp, uPhi,
  uStrings;

function ap_cBrush: Tvalue;
begin
  result := cBrush;
end;

procedure Brush_setup(obj: Tvalue; real: TBrush);
begin
//  ap_iv_set(obj, '@bitmap', Bitmap_alloc(cBitmap, real.Bitmap));
end;

function Brush_alloc(klass: Tvalue; real: TBrush): Tvalue;
begin
  result := TmpAlloc(klass, real);
  Brush_setup(result, real);
end;

function ap_iBrush(real: TBrush; owner: Tvalue): Tvalue;
begin
  result := Brush_alloc(cBrush, real);
  ap_owner(result, owner);
end;

function Brush_new(This: Tvalue): Tvalue; cdecl;
var
  real: TBrush;
begin
  real := TBrush.Create;
  result := ObjAlloc(This, real);
  Brush_setup(result, real);
  ap_obj_call_init(result, 0, nil);
end;

function Brush_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TBrush;
  source: TPersistent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPersistent, source);
  real.Assign(source);
  result := v;
end;

procedure Init_Brush;
begin
  OutputConstSetType(mPhi, TypeInfo(TBrushStyle));

  cBrush := rb_define_class_under(mPhi, 'Brush', ap_cObject);
  OutputProp(cBrush, TBrush);

  rb_define_singleton_method(cBrush, 'new', @Brush_new, 0);
  rb_define_method(cStrings, 'assign', @Brush_assign, 1);
end;

end.
