unit uAnyComponent;

interface

uses
  SysUtils, Classes,
{$IFDEF VCL}
  Forms,
{$ELSE}
  QForms,
{$ENDIF}
  Rubies;

function ap_iAnyComponent_v(var Component; owner: Tvalue): Tvalue;
(*
  Cӂ Delphi Component ɑΉ Ruby Object ԂB

  GetAllocFunc ɂăNX PhiAllocFuncList Ɋ܂܂ĂȂ
  ꍇɂ̊֐ԂB

  : var Component
    Cӂ Delphi Component

  Ɏw肵 Component  Delphi Class ɑΉ Ruby Class 
  AnyRubyClassList TBȂ Ruby Class 𐶐
  AnyRubyClassList ɉB
*)

function AnyForm_alloc(real: TForm): Tvalue;
(*
  Cӂ Delphi Form ɑΉ Ruby Object ԂB

  PhiLoadForm Ă΂B

  : real: TForm
    Cӂ Delphi Form

  Ɏw肵 real Form  Delphi Class ɑΉ Ruby Class 
  AnyRubyClassList TBȂ Ruby Class 𐶐
  AnyRubyClassList ɉB
*)

implementation

uses
  uHandle, uAlloc, uPhi, uProp, uComponent, uForm;

var
  AnyRubyClassList: TStringList;

function DefineRubyClass(real: TPersistent; super: Tvalue): Tvalue;
var
  AClass: TPersistentClass;
  S: string;
  i: Integer;
begin
  AClass := TPersistentClass(real.ClassType);
  RegisterClass(AClass);
  S := real.ClassName;
  i := AnyRubyClassList.IndexOf(S);
  if i < 0 then
  begin
    result := rb_define_class_under(mPhi, PChar(S)+1, super);
    AnyRubyClassList.AddObject(S, Pointer(result));
    DefineProp(result, AClass);
  end else
    result := Tvalue(AnyRubyClassList.Objects[i])
  ;
end;

function ap_iAnyComponent_v(var Component; owner: Tvalue): Tvalue;
var
  real: TComponent;
  cAny: Tvalue;
begin
  real := TComponent(Component);
  cAny := DefineRubyClass(real, ap_cObject);
  result := ChildAlloc(cAny, real);
  ap_owner(result, owner);
//    AssignPropMethod(real, [Handle]);
end;

function AnyForm_alloc(real: TForm): Tvalue;
var
  cAny: Tvalue;
begin
  cAny := DefineRubyClass(real, cForm);
  result := ChildAlloc(cAny, real);
  Form_setup(result, real);
end;

initialization
  AnyRubyClassList := TStringList.Create;

finalization
  AnyRubyClassList.Free;

end.
