unit oAppPath;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

//{$define dll_test}

type
  TFormAppPath = class(TForm)
    lblPath1: TLabel;
    lblPath2: TLabel;
    lblPath3: TLabel;
    btnRegist: TButton;
    btnDelete: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnRegistClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
  private
    procedure UpdateInfo;
  public
  end;

var
  FormAppPath: TFormAppPath;

implementation

uses uAppPath;

{$R *.DFM}

{$if defined(dll_test)}
type
  TExe_names = array[1..3] of String;
const
  Exe_Names : TExe_Names = ( 'Apollo.exe' ,  'ruby_ap.exe' , 'mswin32-ruby16.dll' );
{$else}
type
  TExe_names = array[1..2] of String;
const
  Exe_Names : TExe_Names = ( 'Apollo.exe' ,  'ruby_ap.exe' );
{$ifend}

procedure RegistAppPath;
var
  pwd: string;
  i:integer;
begin
  pwd := ExtractFileDir(ParamStr(0));
  for i := low(Exe_Names) to high(Exe_Names) do SetAppPath( Exe_Names[i] , pwd);
  //SetAppPath('Apollo.exe', pwd);
  //SetAppPath('ruby_ap.exe', pwd);
end;

procedure DeleteAppPath;
var
  i:integer;
begin
  for i := low(Exe_Names) to high(Exe_Names) do DelAppPath( Exe_Names[i] );
  //DelAppPath('Apollo.exe');
  //DelAppPath('ruby_ap.exe');
end;

procedure TFormAppPath.UpdateInfo;
begin
  lblPath1.Caption := GetAppPath( Exe_Names[1] );
  lblPath2.Caption := GetAppPath( Exe_Names[2] );
{$if defined(dll_test)}
  lblPath3.Caption := GetAppPath( Exe_Names[3] );
{$ifend}
  //lblPath1.Caption := GetAppPath('Apollo.exe');
  //lblPath2.Caption := GetAppPath('ruby_ap.exe');
end;

procedure TFormAppPath.FormCreate(Sender: TObject);
begin
  UpdateInfo;
end;

procedure TFormAppPath.btnRegistClick(Sender: TObject);
begin
  RegistAppPath;
  UpdateInfo;
end;

procedure TFormAppPath.btnDeleteClick(Sender: TObject);
begin
  DeleteAppPath;
  UpdateInfo;
end;

end.
