unit uSCGCellFont;

interface

uses
  StrCGrid, Rubies;  

var
   cSCGCellFont: Tvalue;
   cSCGCellFonts: Tvalue;

function ap_cCellFonts: Tvalue;
function ap_iSCGCellFont(real: TSCGCellFont; owner: Tvalue): Tvalue;
function ap_iSCGCellFonts(real: TSCGCellFonts; owner: Tvalue): Tvalue;
procedure Init_SCGCellFont;

implementation

uses  SysUtils, StdCtrls, uDefUtils, Pythia, uSCG;

procedure SCGCellFont_setup(obj: Tvalue; real: TSCGCellFont);
begin
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
end;

function SCGCellFont_get_font(This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFont;
begin
   real := ap_data_get_struct(This);
   result := ap_iFont(real.Font, This);
end;

function SCGCellFont_set_font(This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFont;
begin
   real := ap_data_get_struct(This);
   real.Font := ap_data_get_struct(This);
   result := This;
end;

   
function SCGCellFont_alloc(This: Tvalue; real: TSCGCellFont): Tvalue;
begin
   result := TmpAlloc(This, real);
   SCGCellFont_setup(result, real);
end;

function ap_iSCGCellFont(real: TSCGCellFont; owner: Tvalue): Tvalue;
begin
   result := SCGCellFont_alloc(cSCGCellFont, real);
   ap_owner(result, owner);
end;
   
function ap_iSCGCellFont_v(var AControl; owner: Tvalue): Tvalue;
begin
   result := ap_iSCGCellFont(TSCGCellFont(AControl), owner);
end;
   
function SCGCellFont_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFont;
begin
   real := TSCGCellFont.Create(nil);
   result := ObjAlloc(This, real);
   SCGCellFont_setup(result, real);
   ap_obj_call_init(result, argc, argv);
end;
   
function ap_cCellFonts: Tvalue;
begin
  result := cSCGCellFonts;
end;

procedure SCGCellFonts_setup(obj: Tvalue; real: TSCGCellFonts);
begin
end;

function SCGCellFonts_alloc(This: Tvalue; real: TSCGCellFonts): Tvalue;
begin
   result := TmpAlloc(This, real);
   SCGCellFonts_setup(result, real);
end;

function ap_iSCGCellFonts(real: TSCGCellFonts; owner: Tvalue): Tvalue;
begin 
   result := SCGCellFonts_alloc(cSCGCellFonts, real);
   ap_owner(result, owner);
end;

function ap_iSCGCellFonts_v(var AControl; owner: Tvalue): Tvalue;
begin 
   result := ap_iSCGCellFonts(TSCGCellFonts(AControl), owner);
end;

function SCGCellFonts_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFonts;
begin
   real := TSCGCellFonts.Create(nil);
   result := ObjAlloc(This, real);
   SCGCellFonts_setup(result, real);
   ap_obj_call_init(result, argc, argv);
end;
   
function SCGCellFont_get_name(This, v: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFont;
begin
   real := ap_data_get_struct(This);
   result := ap_String(real.Name);
end;

function SCGCellFont_set_name(This, v: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFont;
begin
   real := ap_data_get_struct(This);
   real.Name := dl_String(v);
   result := This;
end;

function SCGCellFonts_add(This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFonts;
begin
   real := ap_data_get_struct(This);
   result := ap_iSCGCellFont(real.Add, This);
end;

function SCGCellFonts_index_of_name(This, v: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFonts;
begin
   real := ap_data_get_struct(This);
   result := INT2FIX(real.IndexOfName(dl_String(v)));
end;

function SCGCellFonts_get_items(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFonts;
   args: array of Tvalue;
begin
   if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
   SetLength(args, argc);
   args := argv;
   real := ap_data_get_struct(This);
   result := ap_iSCGCellFont(real.Items[FIX2INT(args[0])], This);
end;
   
function SCGCellFonts_set_items(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFonts;
   args: array of Tvalue;
begin
   if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
   SetLength(args, argc);
   args := argv;
   real := ap_data_get_struct(This);
   real.Items[FIX2INT(args[0])] := ap_data_get_struct(args[1]);
   result := args[1];
end;

function SCGCellFonts_get_item(This, x: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFonts;
begin
   real := ap_data_get_struct(This);
   result := ap_iSCGCellFont(real.Items[FIX2INT(x)], This);
end;
   
function SCGCellFonts_set_item(This, x, obj: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellFonts;
   font: TSCGCellFont;
begin
   real := ap_data_get_struct(This);
   ap_data_get_object(obj, TSCGCellFont, font);
   real.Items[FIX2INT(x)] := font;
   result := obj;
end;

procedure Init_SCGCellFont;
begin
   cSCGCellFont := DefinePersistentClass(ap_mPhi, TSCGCellFont, ap_cPersistent, ap_iSCGCellFont_v);
   DefineSingletonMethod(cSCGCellFont, 'new', SCGCellFont_new);
//   DefineAttrGet(cSCGCellFont, 'font', @SCGCellFont_get_font);
//   DefineAttrSet(cSCGCellFont, 'font', @SCGCellFont_set_font);
   DefineAttrGet(cSCGCellFont, 'name', @SCGCellFont_get_name);
   DefineAttrSet(cSCGCellFont, 'name', @SCGCellFont_set_name);

   cSCGCellFonts := DefinePersistentClass(ap_mPhi, TSCGCellFonts, ap_cPersistent, ap_iSCGCellFonts_v);
   DefineSingletonMethod(cSCGCellFonts, 'new', SCGCellFonts_new);
   rb_define_method(cSCGCellFonts, 'add', @SCGCellFonts_add, 0);
   rb_define_method(cSCGCellFonts, 'index_of_name', @SCGCellFonts_index_of_name, 0);

   DefineIndexer(cSCGCellFonts, 'items', @SCGCellFonts_get_items, @SCGCellFonts_set_items);
//   rb_define_method(cSCGCellFonts, 'get_item', @SCGCellFonts_get_item, 1);
//   rb_define_method(cSCGCellFonts, 'set_item', @SCGCellFonts_set_item, 2);
end;

end.

