unit SCGHandle;

interface

uses Classes, Rubies, StdCtrls, StrCGrid, Windows, Controls, Graphics, Grids;

type
   TSCGHandle = class(TObject)
   published
     procedure SCGCellChangedOnCellChanged(Sender: TObject; AOldCol, AOldRow, ANewCol, ANewRow: integer);
     procedure SCGColChangedEventOnColChanged(Sender: TObject; AOldCol, ANewCol: integer);
     procedure SCGOutCellTextEventOnOutCellText(Sender: TObject; AGrid: TStrColGrid;
               ARect: TRect; ACol, ARow: integer; ACaption: string; var AValue: string; var ADoCanvasReset: boolean );
     procedure SCGRowChangedEventOnRowChanged(Sender: TObject; AOldRow, ANewRow: integer);
     procedure SCGDrawTextOneLineEventOnDrawTextOneLine(Sender: TObject; AGrid: TStrColGrid;
               ARect: TRect; ACol, ARow, AIndex: integer; AState: TGridDrawState;
               var AText: string; var AAlignment: TAlignment; var ALayout: TTextLayout;
               var AInnerHorzLine: boolean );
     procedure SCGParamsCellChangedEventOnEnterCell(Sender: TObject; AGrid: TStrColGrid; AOldCol, AOldRow, ANewCol, ANewRow: integer);
     procedure SCGParamsCellChangedEventOnExitCell(Sender: TObject; AGrid: TStrColGrid; AOldCol, AOldRow, ANewCol, ANewRow: integer);
     procedure SCGParamsColChangedEventOnEnterCol(Sender: TObject; AGrid: TStrColGrid; AOldCol, ANewCol: integer);
     procedure SCGParamsColChangedEventOnExitCol(Sender: TObject; AGrid: TStrColGrid; AOldCol, ANewCol: integer);
     procedure SCGParamsRowChangedEventOnEnterRow(Sender: TObject; AGrid: TStrColGrid; AOldRow, ANewRow: integer);
     procedure SCGParamsRowChangedEventOnExitRow(Sender: TObject; AGrid: TStrColGrid; AOldRow, ANewRow: integer);
     procedure SCGDrawCellEventOnDrawCell(Sender: TObject; AGrid: TStrColGrid; Col, Row: Longint; Rect: TRect; State: TGridDrawState);
   end;

implementation

uses Pythia, uSCGrid;

{ BeforeDraw: TNotifyEvent ??}

procedure TSCGHandle.SCGCellChangedOnCellChanged(Sender: TObject; AOldCol, AOldRow, ANewCol, ANewRow: integer);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_cell_changed'));
  rb_ary_push(data, recv);
  rb_ary_push(data, INT2FIX(AOldCol));
  rb_ary_push(data, INT2FIX(AOldRow));
  rb_ary_push(data, INT2FIX(ANewCol));
  rb_ary_push(data, INT2FIX(ANewRow));
  
  PhiCallProtect(data);
end;

procedure TSCGHandle.SCGColChangedEventOnColChanged(Sender: TObject; AOldCol, ANewCol: integer);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_col_changed'));
  rb_ary_push(data, recv);
  rb_ary_push(data, INT2FIX(AOldCol));
  rb_ary_push(data, INT2FIX(ANewCol));

  PhiCallProtect(data);
end;

procedure TSCGHandle.SCGOutCellTextEventOnOutCellText(Sender: TObject; AGrid: TStrColGrid;
               ARect: TRect; ACol, ARow: integer; ACaption: string; var AValue: string; var ADoCanvasReset: boolean );
var
  recv, data, val, ret, ary: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_out_cell_text'));
  rb_ary_push(data, recv);

  ary := rb_ary_new;
  rb_ary_push(ary, ap_String(AValue));
  rb_ary_push(ary, ap_Bool(ADoCanvasReset));
  rb_ary_push(data, ary);

  rb_ary_push(data, ap_iStrColGrid(AGrid, recv));
  rb_ary_push(data, ap_iRect(ARect, recv));
  rb_ary_push(data, INT2FIX(ACol));
  rb_ary_push(data, INT2FIX(ARow));
  rb_ary_push(data, ap_String(ACaption));

  ret := PhiCallProtect(data);
  if RTYPE(ret) <> T_ARRAY then Exit;
  val := rb_ary_shift(ret);
  AValue := dl_String(val);
  val := rb_ary_shift(ret);
  ADoCanvasReset := RTEST(val);
end;

procedure TSCGHandle.SCGRowChangedEventOnRowChanged(Sender: TObject; AOldRow, ANewRow: integer);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_row_changed'));
  rb_ary_push(data, recv);
  rb_ary_push(data, INT2FIX(AOldRow));
  rb_ary_push(data, INT2FIX(ANewRow));

  PhiCallProtect(data);
end;

procedure TSCGHandle.SCGDrawTextOneLineEventOnDrawTextOneLine(Sender: TObject; AGrid: TStrColGrid;
               ARect: TRect; ACol, ARow, AIndex: integer; AState: TGridDrawState;
               var AText: string; var AAlignment: TAlignment; var ALayout: TTextLayout;
               var AInnerHorzLine: boolean );
var
  recv, data, ret, val, ary: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_draw_text_one_line'));
  rb_ary_push(data, recv);

  ary := rb_ary_new;
  rb_ary_push(ary, ap_String(AText));
//  rb_ary_push(ary, ap_set_to_ary(AAlignment));
  rb_ary_push(ary, ap_set_to_ary(ALayout));
  rb_ary_push(ary, ap_Bool(AInnerHorzLine));
  rb_ary_push(data, ary);


  rb_ary_push(data, ap_iStrColGrid(AGrid, recv));
  rb_ary_push(data, ap_iRect(ARect, recv));
  rb_ary_push(data, INT2FIX(ACol));
  rb_ary_push(data, INT2FIX(ARow));
  rb_ary_push(data, ap_set_to_ary(AState));

  ret := PhiCallProtect(data);
  if RTYPE(ret) <> T_ARRAY then Exit;
  val := rb_ary_shift(ret);
  AText := dl_String(val);

//  val := rb_ary_shift(ret);
//  if RTYPE(val) <> T_ARRAY then Exit;
//  val := rb_ary_shift(val);
//  AAlignment := FIX2INT(val);
  val := rb_ary_shift(ret);
  ALayout := TTextLayout(FIX2INT(val));
  val := rb_ary_shift(ret);
  AInnerHorzLine := RTEST(val);
end;

procedure TSCGHandle.SCGParamsCellChangedEventOnEnterCell(Sender: TObject; AGrid: TStrColGrid; AOldCol, AOldRow, ANewCol, ANewRow: integer);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_enter_cell'));
  rb_ary_push(data, recv);

  rb_ary_push(data, ap_iStrColGrid(AGrid, recv));
  rb_ary_push(data, INT2FIX(AOldCol));
  rb_ary_push(data, INT2FIX(AOldRow));
  rb_ary_push(data, INT2FIX(ANewCol));
  rb_ary_push(data, INT2FIX(ANewRow));

  PhiCallProtect(data);
end;

procedure TSCGHandle.SCGParamsCellChangedEventOnExitCell(Sender: TObject; AGrid: TStrColGrid; AOldCol, AOldRow, ANewCol, ANewRow: integer);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_exit_cell'));
  rb_ary_push(data, recv);

  rb_ary_push(data, ap_iStrColGrid(AGrid, recv));
  rb_ary_push(data, INT2FIX(AOldCol));
  rb_ary_push(data, INT2FIX(AOldRow));
  rb_ary_push(data, INT2FIX(ANewCol));
  rb_ary_push(data, INT2FIX(ANewRow));

  PhiCallProtect(data);

end;

procedure TSCGHandle.SCGParamsColChangedEventOnEnterCol(Sender: TObject; AGrid: TStrColGrid; AOldCol, ANewCol: integer);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_enter_col'));
  rb_ary_push(data, recv);

  rb_ary_push(data, ap_iStrColGrid(AGrid, recv));
  rb_ary_push(data, INT2FIX(AOldCol));
  rb_ary_push(data, INT2FIX(ANewCol));

  PhiCallProtect(data);
end;

procedure TSCGHandle.SCGParamsColChangedEventOnExitCol(Sender: TObject; AGrid: TStrColGrid; AOldCol, ANewCol: integer);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_exit_col'));
  rb_ary_push(data, recv);

  rb_ary_push(data, ap_iStrColGrid(AGrid, recv));
  rb_ary_push(data, INT2FIX(AOldCol));
  rb_ary_push(data, INT2FIX(ANewCol));

  PhiCallProtect(data);
end;

procedure TSCGHandle.SCGParamsRowChangedEventOnEnterRow(Sender: TObject; AGrid: TStrColGrid; AOldRow, ANewRow: integer);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_enter_row'));
  rb_ary_push(data, recv);

  rb_ary_push(data, ap_iStrColGrid(AGrid, recv));
  rb_ary_push(data, INT2FIX(AOldRow));
  rb_ary_push(data, INT2FIX(ANewRow));

  PhiCallProtect(data);
end;

procedure TSCGHandle.SCGParamsRowChangedEventOnExitRow(Sender: TObject; AGrid: TStrColGrid; AOldRow, ANewRow: integer);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_exit_row'));
  rb_ary_push(data, recv);

  rb_ary_push(data, ap_iStrColGrid(AGrid, recv));
  rb_ary_push(data, INT2FIX(AOldRow));
  rb_ary_push(data, INT2FIX(ANewRow));

  PhiCallProtect(data);
end;

procedure TSCGHandle.SCGDrawCellEventOnDrawCell(Sender: TObject; AGrid: TStrColGrid; Col, Row: Longint; Rect: TRect; State: TGridDrawState);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_draw_cell'));
  rb_ary_push(data, recv);

  rb_ary_push(data, ap_iStrColGrid(AGrid, recv));
  rb_ary_push(data, INT2FIX(Col));
  rb_ary_push(data, INT2FIX(Row));
  rb_ary_push(data, ap_iRect(Rect, recv));
  rb_ary_push(data, ap_set_to_ary(State));

  PhiCallProtect(data);
end;

end.

