unit uSession;

interface

uses Rubies, DBTables;

var
  cSession: Tvalue;
  vSession: Tvalue;

function ap_cSession: Tvalue;
function ap_vSession: Tvalue;
function ap_iSession(real: TSession; owner: Tvalue): Tvalue;
procedure Init_Session;

implementation

uses Classes, uDefUtils, Pythia, uDatabase, uRDB;

function dl_Session(This: Tvalue): TSession;
begin
  result := ap_data_get_struct(This);
end;

function ap_cSession: Tvalue;
begin
  result := cSession;
end;

function ap_vSession: Tvalue;
begin
  result := vSession;
end;

procedure Session_free(real: TSession); cdecl;
begin
  if real = nil then exit;
  if real.Active then real.Close;
  ChildFree(real);
end;

// ChildAlloc modified
function Session_alloc0(This: Tvalue; real: TSession): Tvalue;
begin
  if real = nil then begin result := Qnil; exit; end;
  result := rb_data_object_alloc(This, real, nil, @Session_free);
  rb_iv_set(result, '@events', rb_hash_new);
  real.tag := result;
end;

function Session_alloc(This: Tvalue; real: TSession): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function ap_iSession(real: TSession; owner: Tvalue): Tvalue;
begin
  result := Session_alloc(cSession, real);
  ap_owner(result, owner);
end;

function ap_iSession_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iSession(TSession(obj), owner)
end;

function Session_get_databases(This: Tvalue): Tvalue; cdecl;
var
  real: TSession;
  I: Integer;
  Database: TDatabase;
  v: Tvalue;
begin
  real := ap_data_get_struct(This);
  result := rb_ary_new;
  for I := 0 to real.DatabaseCount-1 do
  begin
    Database := real.Databases[I];
    v := Database.Tag;
    if v = 0 then v := ap_iDatabase(Database, This);
    rb_ary_push(result, v);
  end;
end;

function Session_get_database_count(This: Tvalue): Tvalue; cdecl;
var
  real: TSession;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.DatabaseCount);
end;

function Session_add_alias(This, name, driver, strings: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_Session(This).AddAlias(dl_String(name), dl_String(driver), dl_Strings(strings));
end;

function Session_add_standard_alias(This, name, path, driver: Tvalue): Tvalue; cdecl;
var
  real: TSession;
begin
  real := ap_data_get_struct(This);
  try
    real.AddStandardAlias(dl_String(name), dl_String(path), dl_String(driver));
  except
    on E: EDBEngineError do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function Session_modify_alias(This, name, strings: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_Session(This).ModifyAlias(dl_String(name), dl_Strings(strings));
end;

function Session_save_config_file(This: Tvalue): Tvalue; cdecl;
var
  real: TSession;
begin
  real := ap_data_get_struct(This);
  real.SaveConfigFile;
  result := This;
end;

function Session_get_config_mode(This: Tvalue): Tvalue; cdecl;
var
  real: TSession;
  mode: TConfigMode;
  v: Tvalue;
begin
  real := ap_data_get_struct(This);
  mode := real.ConfigMode;
  v := rb_ary_new;
  if cfmVirtual    in mode then rb_ary_push(v, INT2FIX(Ord(cfmVirtual   )));
  if cfmPersistent in mode then rb_ary_push(v, INT2FIX(Ord(cfmPersistent)));
  if cfmSession    in mode then rb_ary_push(v, INT2FIX(Ord(cfmSession   )));
  result := v;
end;

function Session_set_config_mode(This, v: Tvalue): Tvalue; cdecl;
var
  len: Integer;
  ptr: Pvalue;
  mode: TConfigMode;
  n: Integer;
  real: TSession;
begin
  Check_Type(v, T_ARRAY);
  len := ap_ary_len(v);
  ptr := ap_ary_ptr(v);
  mode := [];
  while len > 0 do
  begin
    n := FIX2INT(ptr^);
    if (n < Ord(Low(TConfigModes))) or (Ord(High(TConfigModes)) < n) then
      ap_raise(ap_eIndexError, sOut_of_range);
    Include(mode, TConfigModes(FIX2INT(ptr^)));
    Dec(len);
    Inc(ptr);
  end;
  real := ap_data_get_struct(This);
  real.ConfigMode := mode;
  result := v;
end;

function Session_get_alias_names(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_StringList_new;
  dl_Session(This).GetAliasNames(dl_Strings(result));
end;

function Session_get_alias_params(This, name: Tvalue): Tvalue; cdecl;
begin
  result := ap_StringList_new;
  dl_Session(This).GetAliasParams(dl_String(name), dl_Strings(result));
end;

function Session_get_driver_names(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_StringList_new;
  dl_Session(This).GetDriverNames(dl_Strings(result));
end;

function Session_get_alias_driver_name(This, name: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Session(This).GetAliasDriverName(dl_String(name)));
end;

function Session_get_database_names(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_StringList_new;
  dl_Session(This).GetDatabaseNames(dl_Strings(result));
end;

function Session_get_table_names(This, database_name, patterns, extensions, system_tables: Tvalue): Tvalue; cdecl;
begin
  result := ap_StringList_new;
  dl_Session(This).GetTableNames(
    dl_String(database_name),
    dl_String(patterns),
    dl_Boolean(extensions),
    dl_Boolean(system_tables),
    dl_Strings(result)
  );
end;

procedure Regist_Session;
var
  real: TSession;
  obj, module: Tvalue;
begin
  real := Session;
  obj := Session_alloc0(cSession, real);
  vSession := obj;
  rb_define_const(mRDB, 'SESSION', obj);

  module := rb_module_new;
  rb_extend_object(obj, module);
  rb_iv_set(obj, '@child_attr_module', module);
end;

procedure Init_Session;
begin
  DefineConstSetType(mRDB, TypeInfo(TConfigModes));

  cSession := DefinePersistentClass(mRDB, TSession, ap_cPersistent, ap_iSession_v);

  DefineAttrGet(cSession, 'databases', Session_get_databases);
  DefineAttrGet(cSession, 'database_count', Session_get_database_count);

  rb_define_method(cSession, 'add_alias', @Session_add_alias, 3);
  rb_define_method(cSession, 'add_standard_alias', @Session_add_standard_alias, 3);
  rb_define_method(cSession, 'modify_alias', @Session_modify_alias, 2);
  rb_define_method(cSession, 'save_config_file', @Session_save_config_file, 0);

  DefineAttrGet(cSession, 'config_mode', Session_get_config_mode);
  DefineAttrSet(cSession, 'config_mode', Session_set_config_mode);

  rb_define_method(cSession, 'alias_names', @Session_get_alias_names, 0);
  rb_define_method(cSession, 'alias_params', @Session_get_alias_params, 1);
  rb_define_method(cSession, 'driver_names', @Session_get_driver_names, 0);
  rb_define_method(cSession, 'alias_driver_name', @Session_get_alias_driver_name, 1);
  rb_define_method(cSession, 'database_names', @Session_get_database_names, 0);
  rb_define_method(cSession, 'table_names', @Session_get_table_names, 4);

  Regist_Session;
end;

end.
