unit uSQLQuery;

interface

uses Rubies;

var
  cSQLQuery: Tvalue;

procedure Init_SQLQuery;

implementation

uses SysUtils, SqlExpr, uDefUtils, Pythia, uRDB, uDataSet, uParam;

function SQLQuery_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLQuery;
begin
  real := TSQLQuery.Create(nil);
  result := DataSet_alloc1(This, real);
  DataSet_setup(result, real);

  rb_obj_call_init(result, argc, argv);
end;

function SQLQuery_execute(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLQuery;
  args: array of Tvalue;
begin
  real := ap_data_get_struct(This);

  if argc > 0 then
  begin
    SetLength(args, argc);
    args := argv;
    real.Close;
    real.SQL.Text := dl_String(args[0]);
  end;
  try
    real.ExecSQL;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := Qnil;
end;

function SQLQuery_exec_sql(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLQuery;
  args: array of Tvalue;
  ExecDirect : boolean;
begin
  result := Qnil;
  real := ap_data_get_struct(This);
  ExecDirect := False; // default
  if argc > 0 then
  begin
    SetLength(args, argc);
    args := argv;
    ExecDirect := dl_Boolean(args[0]);
  end;
  try
    result := ap_Integer(real.ExecSQL(ExecDirect));
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

function SQLQuery_open(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLQuery;
  args: array of Tvalue;
begin
  real := ap_data_get_struct(This);
  if argc > 0 then
  begin
    SetLength(args, argc);
    args := argv;
    real.Close;
    real.SQL.Text := dl_String(args[0]);
  end;
//  try
    real.Open;
//  except
//    on E: Exception do
//      ap_raise(ap_eDatabaseError, E.message);
//  end;
  result := This;
end;

function SQLQuery_get_sql(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLQuery;
begin
  real := ap_data_get_struct(This);
  result := ap_iStrings(real.SQL, This);
end;

function SQLQuery_get_params(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLQuery;
begin
  real := ap_data_get_struct(This);
  result := ap_iParams(real.Params, This);
end;

procedure Init_SQLQuery;
begin
  cSQLQuery := DefinePersistentClass(mRDB, TSQLQuery, cDataSet, nil);
  DefineSingletonMethod(cSQLQuery, 'new', SQLQuery_new);
  DefineMethod(cSQLQuery, 'execute', SQLQuery_execute);
  rb_define_method(cSQLQuery, 'exec_sql', @SQLQuery_exec_sql, -1);
//  rb_define_method(cSQLQuery, 'open', @SQLQuery_open, -1);
  DefineAttrGet(cSQLQuery, 'sql', SQLQuery_get_sql);
  DefineAttrGet(cSQLQuery, 'params', SQLQuery_get_params);
end;

end.
