unit uColumn;

interface

uses
{$IFDEF VCL}
  DBGrids,
{$ELSE}
  QDBGrids,
{$ENDIF}
  Rubies;

var
  cColumn, cColumns: Tvalue;

function ap_cColumn: Tvalue;
function ap_iColumn(real: TColumn; owner: Tvalue): Tvalue;
function ap_iColumns(real: TDBGridColumns; owner: Tvalue): Tvalue;
procedure Init_Column;

implementation

uses Classes, uDefUtils, Pythia, uRDB, uField;

function ap_cColumn: Tvalue;
begin
  result := cColumn;
end;

procedure Column_setup(obj: Tvalue; real: TColumn);
begin
  rb_iv_set(obj, '@field', ap_iField(real.Field, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
end;

function Column_alloc(This: Tvalue; real: TColumn): Tvalue;
begin
  result := TmpAlloc(This, real);
  Column_setup(result, real);
end;

function ap_iColumn(real: TColumn; owner: Tvalue): Tvalue;
begin
  result := Column_alloc(cColumn, real);
  ap_owner(result, owner);
end;

function ap_iColumn_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iColumn(TColumn(obj), owner)
end;

procedure Columns_setup(obj: Tvalue; real: TDBGridColumns);
begin
  Collection_setup(obj, real);
end;

function Columns_alloc(This: Tvalue; real: TDBGridColumns): Tvalue;
begin
  result := TmpAlloc(This, real);
  Columns_setup(result, real);
end;

function ap_iColumns(real: TDBGridColumns; owner: Tvalue): Tvalue;
begin
  result := Columns_alloc(cColumns, real);
  ap_owner(result, owner);
end;

function ap_iColumns_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iColumns(TDBGridColumns(obj), owner);
end;

function ColumnByName(real: TDBGridColumns; name: string): TColumn;
var
  n: Integer;
begin
  for n := 0 to real.Count-1 do
    if real[n].FieldName = name then
    begin
      result := real[n];
      exit
    end;
  result := nil;
end;

function Columns_aref(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDBGridColumns;
  Column: TColumn;
  S: String;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  Column := nil;

  case RTYPE(v) of
  T_STRING:
    begin
      S := dl_String(v);
      Column := ColumnByName(real, S);
    end;
  T_FIXNUM:
    begin
      n := FIX2INT(v);
      if (n < 0) or (real.Count <= n) then
        ap_raise(ap_eIndexError, sOut_of_range);
      Column := real[n];
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;
  if Column = nil then
    result := Qnil
  else
    result := Collection_aref(This, ap_Fixnum(Column.Index));
end;

procedure Init_Column;
begin
  cColumn := DefinePersistentClass(mRDB, TColumn, ap_cCollectionItem, ap_iColumn_v);
  rb_define_attr(cColumn, 'field', 1, 0);
  rb_define_attr(cColumn, 'font', 1, 0);

  cColumns := DefinePersistentClass(mRDB, TDBGridColumns, ap_cCollection, ap_iColumns_v);
  SetCollectionItemClass(cColumns, 'TColumn');
  rb_define_method(cColumns, '[]', @Columns_aref, 1);
end;

end.
