library Ole;

uses
  Windows, SysUtils, Classes, Controls, OleCtnrs, OleHandle,
  Rubies, uDefUtils, Pythia, PhiForm;

{$E so}

var
  Handle: TOleHandle;

procedure OleContainer_setup(obj: Tvalue; real: TOleContainer);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  ap_set_child_attr_module(obj);
  if @real.OnObjectMove = nil then real.OnObjectMove := Handle.doObjectMove;
//    AssignPropMethod(real, [PhiGetHandle]);
end;

function OleContainer_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [PhiGetHandle]);
  result := Qnil;
end;

function OleContainer_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TOleContainer;
begin
  real := TOleContainer.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  OleContainer_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function OleContainer_insert_object_dialog(This: Tvalue): Tvalue; cdecl;
var
  real: TOleContainer;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.InsertObjectDialog);
end;

function OleContainer_do_verb(This, verb: Tvalue): Tvalue; cdecl;
var
  real: TOleContainer;
begin
  real := ap_data_get_struct(This);
  real.DoVerb(FIX2INT(verb));
  result := This;
end;

function OleContainer_get_primary_verb(This: Tvalue): Tvalue; cdecl;
var
  real: TOleContainer;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.PrimaryVerb);
end;

procedure Init_ole; cdecl;
begin
  if ap_mPhi = 0 then ap_loaderror('undefined Phi module');

  Handle := TOleHandle.Create;
  PhiExtentList.Add(Handle);

  rb_eOleError := rb_define_class_under(ap_mPhi, 'OleError', ap_eStandardError);

  cOleContainer := DefinePersistentClass(ap_mPhi, TOleContainer, ap_cWinControl, nil);

  rb_define_method(cOleContainer, 'event_handle', @OleContainer_event_handle, 1);
  DefineSingletonMethod(cOleContainer, 'new', OleContainer_new);

  rb_define_method(cOleContainer, 'insert_object_dialog', @OleContainer_insert_object_dialog, 0);
  rb_define_method(cOleContainer, 'do_verb', @OleContainer_do_verb, 1);
  DefineAttrGet(cOleContainer, 'primary_verb', OleContainer_get_primary_verb);
end;

exports
  Init_ole;

end.
